/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directconnect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.directconnect.model.ConnectionState;
import software.amazon.awssdk.services.directconnect.model.DirectConnectResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ConfirmConnectionResponse
extends DirectConnectResponse
implements ToCopyableBuilder<Builder, ConfirmConnectionResponse> {
    private static final SdkField<String> CONNECTION_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("connectionState").getter(ConfirmConnectionResponse.getter(ConfirmConnectionResponse::connectionStateAsString)).setter(ConfirmConnectionResponse.setter(Builder::connectionState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectionState").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTION_STATE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ConfirmConnectionResponse.memberNameToFieldInitializer();
    private final String connectionState;

    private ConfirmConnectionResponse(BuilderImpl builder) {
        super(builder);
        this.connectionState = builder.connectionState;
    }

    public final ConnectionState connectionState() {
        return ConnectionState.fromValue(this.connectionState);
    }

    public final String connectionStateAsString() {
        return this.connectionState;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionStateAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfirmConnectionResponse)) {
            return false;
        }
        ConfirmConnectionResponse other = (ConfirmConnectionResponse)((Object)obj);
        return Objects.equals(this.connectionStateAsString(), other.connectionStateAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ConfirmConnectionResponse").add("ConnectionState", (Object)this.connectionStateAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "connectionState": {
                return Optional.ofNullable(clazz.cast(this.connectionStateAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("connectionState", CONNECTION_STATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ConfirmConnectionResponse, T> g) {
        return obj -> g.apply((ConfirmConnectionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DirectConnectResponse.BuilderImpl
    implements Builder {
        private String connectionState;

        private BuilderImpl() {
        }

        private BuilderImpl(ConfirmConnectionResponse model) {
            super(model);
            this.connectionState(model.connectionState);
        }

        public final String getConnectionState() {
            return this.connectionState;
        }

        public final void setConnectionState(String connectionState) {
            this.connectionState = connectionState;
        }

        @Override
        public final Builder connectionState(String connectionState) {
            this.connectionState = connectionState;
            return this;
        }

        @Override
        public final Builder connectionState(ConnectionState connectionState) {
            this.connectionState(connectionState == null ? null : connectionState.toString());
            return this;
        }

        @Override
        public ConfirmConnectionResponse build() {
            return new ConfirmConnectionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends DirectConnectResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ConfirmConnectionResponse> {
        public Builder connectionState(String var1);

        public Builder connectionState(ConnectionState var1);
    }
}

