/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devopsguru.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.devopsguru.model.KMSServerSideEncryptionIntegration;
import software.amazon.awssdk.services.devopsguru.model.LogsAnomalyDetectionIntegration;
import software.amazon.awssdk.services.devopsguru.model.OpsCenterIntegration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ServiceIntegrationConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ServiceIntegrationConfig> {
    private static final SdkField<OpsCenterIntegration> OPS_CENTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OpsCenter").getter(ServiceIntegrationConfig.getter(ServiceIntegrationConfig::opsCenter)).setter(ServiceIntegrationConfig.setter(Builder::opsCenter)).constructor(OpsCenterIntegration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OpsCenter").build()}).build();
    private static final SdkField<LogsAnomalyDetectionIntegration> LOGS_ANOMALY_DETECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LogsAnomalyDetection").getter(ServiceIntegrationConfig.getter(ServiceIntegrationConfig::logsAnomalyDetection)).setter(ServiceIntegrationConfig.setter(Builder::logsAnomalyDetection)).constructor(LogsAnomalyDetectionIntegration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogsAnomalyDetection").build()}).build();
    private static final SdkField<KMSServerSideEncryptionIntegration> KMS_SERVER_SIDE_ENCRYPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("KMSServerSideEncryption").getter(ServiceIntegrationConfig.getter(ServiceIntegrationConfig::kmsServerSideEncryption)).setter(ServiceIntegrationConfig.setter(Builder::kmsServerSideEncryption)).constructor(KMSServerSideEncryptionIntegration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KMSServerSideEncryption").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OPS_CENTER_FIELD, LOGS_ANOMALY_DETECTION_FIELD, KMS_SERVER_SIDE_ENCRYPTION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ServiceIntegrationConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final OpsCenterIntegration opsCenter;
    private final LogsAnomalyDetectionIntegration logsAnomalyDetection;
    private final KMSServerSideEncryptionIntegration kmsServerSideEncryption;

    private ServiceIntegrationConfig(BuilderImpl builder) {
        this.opsCenter = builder.opsCenter;
        this.logsAnomalyDetection = builder.logsAnomalyDetection;
        this.kmsServerSideEncryption = builder.kmsServerSideEncryption;
    }

    public final OpsCenterIntegration opsCenter() {
        return this.opsCenter;
    }

    public final LogsAnomalyDetectionIntegration logsAnomalyDetection() {
        return this.logsAnomalyDetection;
    }

    public final KMSServerSideEncryptionIntegration kmsServerSideEncryption() {
        return this.kmsServerSideEncryption;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.opsCenter());
        hashCode = 31 * hashCode + Objects.hashCode(this.logsAnomalyDetection());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsServerSideEncryption());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceIntegrationConfig)) {
            return false;
        }
        ServiceIntegrationConfig other = (ServiceIntegrationConfig)obj;
        return Objects.equals(this.opsCenter(), other.opsCenter()) && Objects.equals(this.logsAnomalyDetection(), other.logsAnomalyDetection()) && Objects.equals(this.kmsServerSideEncryption(), other.kmsServerSideEncryption());
    }

    public final String toString() {
        return ToString.builder((String)"ServiceIntegrationConfig").add("OpsCenter", (Object)this.opsCenter()).add("LogsAnomalyDetection", (Object)this.logsAnomalyDetection()).add("KMSServerSideEncryption", (Object)this.kmsServerSideEncryption()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OpsCenter": {
                return Optional.ofNullable(clazz.cast(this.opsCenter()));
            }
            case "LogsAnomalyDetection": {
                return Optional.ofNullable(clazz.cast(this.logsAnomalyDetection()));
            }
            case "KMSServerSideEncryption": {
                return Optional.ofNullable(clazz.cast(this.kmsServerSideEncryption()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("OpsCenter", OPS_CENTER_FIELD);
        map.put("LogsAnomalyDetection", LOGS_ANOMALY_DETECTION_FIELD);
        map.put("KMSServerSideEncryption", KMS_SERVER_SIDE_ENCRYPTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ServiceIntegrationConfig, T> g) {
        return obj -> g.apply((ServiceIntegrationConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private OpsCenterIntegration opsCenter;
        private LogsAnomalyDetectionIntegration logsAnomalyDetection;
        private KMSServerSideEncryptionIntegration kmsServerSideEncryption;

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceIntegrationConfig model) {
            this.opsCenter(model.opsCenter);
            this.logsAnomalyDetection(model.logsAnomalyDetection);
            this.kmsServerSideEncryption(model.kmsServerSideEncryption);
        }

        public final OpsCenterIntegration.Builder getOpsCenter() {
            return this.opsCenter != null ? this.opsCenter.toBuilder() : null;
        }

        public final void setOpsCenter(OpsCenterIntegration.BuilderImpl opsCenter) {
            this.opsCenter = opsCenter != null ? opsCenter.build() : null;
        }

        @Override
        public final Builder opsCenter(OpsCenterIntegration opsCenter) {
            this.opsCenter = opsCenter;
            return this;
        }

        public final LogsAnomalyDetectionIntegration.Builder getLogsAnomalyDetection() {
            return this.logsAnomalyDetection != null ? this.logsAnomalyDetection.toBuilder() : null;
        }

        public final void setLogsAnomalyDetection(LogsAnomalyDetectionIntegration.BuilderImpl logsAnomalyDetection) {
            this.logsAnomalyDetection = logsAnomalyDetection != null ? logsAnomalyDetection.build() : null;
        }

        @Override
        public final Builder logsAnomalyDetection(LogsAnomalyDetectionIntegration logsAnomalyDetection) {
            this.logsAnomalyDetection = logsAnomalyDetection;
            return this;
        }

        public final KMSServerSideEncryptionIntegration.Builder getKmsServerSideEncryption() {
            return this.kmsServerSideEncryption != null ? this.kmsServerSideEncryption.toBuilder() : null;
        }

        public final void setKmsServerSideEncryption(KMSServerSideEncryptionIntegration.BuilderImpl kmsServerSideEncryption) {
            this.kmsServerSideEncryption = kmsServerSideEncryption != null ? kmsServerSideEncryption.build() : null;
        }

        @Override
        public final Builder kmsServerSideEncryption(KMSServerSideEncryptionIntegration kmsServerSideEncryption) {
            this.kmsServerSideEncryption = kmsServerSideEncryption;
            return this;
        }

        public ServiceIntegrationConfig build() {
            return new ServiceIntegrationConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ServiceIntegrationConfig> {
        public Builder opsCenter(OpsCenterIntegration var1);

        default public Builder opsCenter(Consumer<OpsCenterIntegration.Builder> opsCenter) {
            return this.opsCenter((OpsCenterIntegration)((OpsCenterIntegration.Builder)OpsCenterIntegration.builder().applyMutation(opsCenter)).build());
        }

        public Builder logsAnomalyDetection(LogsAnomalyDetectionIntegration var1);

        default public Builder logsAnomalyDetection(Consumer<LogsAnomalyDetectionIntegration.Builder> logsAnomalyDetection) {
            return this.logsAnomalyDetection((LogsAnomalyDetectionIntegration)((LogsAnomalyDetectionIntegration.Builder)LogsAnomalyDetectionIntegration.builder().applyMutation(logsAnomalyDetection)).build());
        }

        public Builder kmsServerSideEncryption(KMSServerSideEncryptionIntegration var1);

        default public Builder kmsServerSideEncryption(Consumer<KMSServerSideEncryptionIntegration.Builder> kmsServerSideEncryption) {
            return this.kmsServerSideEncryption((KMSServerSideEncryptionIntegration)((KMSServerSideEncryptionIntegration.Builder)KMSServerSideEncryptionIntegration.builder().applyMutation(kmsServerSideEncryption)).build());
        }
    }
}

