/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devopsguru.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.devopsguru.model.PerformanceInsightsMetricQuery;
import software.amazon.awssdk.services.devopsguru.model.PerformanceInsightsReferenceData;
import software.amazon.awssdk.services.devopsguru.model.PerformanceInsightsReferenceDataListCopier;
import software.amazon.awssdk.services.devopsguru.model.PerformanceInsightsStat;
import software.amazon.awssdk.services.devopsguru.model.PerformanceInsightsStatsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PerformanceInsightsMetricsDetail
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PerformanceInsightsMetricsDetail> {
    private static final SdkField<String> METRIC_DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MetricDisplayName").getter(PerformanceInsightsMetricsDetail.getter(PerformanceInsightsMetricsDetail::metricDisplayName)).setter(PerformanceInsightsMetricsDetail.setter(Builder::metricDisplayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricDisplayName").build()}).build();
    private static final SdkField<String> UNIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Unit").getter(PerformanceInsightsMetricsDetail.getter(PerformanceInsightsMetricsDetail::unit)).setter(PerformanceInsightsMetricsDetail.setter(Builder::unit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Unit").build()}).build();
    private static final SdkField<PerformanceInsightsMetricQuery> METRIC_QUERY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MetricQuery").getter(PerformanceInsightsMetricsDetail.getter(PerformanceInsightsMetricsDetail::metricQuery)).setter(PerformanceInsightsMetricsDetail.setter(Builder::metricQuery)).constructor(PerformanceInsightsMetricQuery::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricQuery").build()}).build();
    private static final SdkField<List<PerformanceInsightsReferenceData>> REFERENCE_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ReferenceData").getter(PerformanceInsightsMetricsDetail.getter(PerformanceInsightsMetricsDetail::referenceData)).setter(PerformanceInsightsMetricsDetail.setter(Builder::referenceData)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReferenceData").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PerformanceInsightsReferenceData::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<PerformanceInsightsStat>> STATS_AT_ANOMALY_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("StatsAtAnomaly").getter(PerformanceInsightsMetricsDetail.getter(PerformanceInsightsMetricsDetail::statsAtAnomaly)).setter(PerformanceInsightsMetricsDetail.setter(Builder::statsAtAnomaly)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatsAtAnomaly").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PerformanceInsightsStat::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<PerformanceInsightsStat>> STATS_AT_BASELINE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("StatsAtBaseline").getter(PerformanceInsightsMetricsDetail.getter(PerformanceInsightsMetricsDetail::statsAtBaseline)).setter(PerformanceInsightsMetricsDetail.setter(Builder::statsAtBaseline)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatsAtBaseline").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PerformanceInsightsStat::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METRIC_DISPLAY_NAME_FIELD, UNIT_FIELD, METRIC_QUERY_FIELD, REFERENCE_DATA_FIELD, STATS_AT_ANOMALY_FIELD, STATS_AT_BASELINE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PerformanceInsightsMetricsDetail.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String metricDisplayName;
    private final String unit;
    private final PerformanceInsightsMetricQuery metricQuery;
    private final List<PerformanceInsightsReferenceData> referenceData;
    private final List<PerformanceInsightsStat> statsAtAnomaly;
    private final List<PerformanceInsightsStat> statsAtBaseline;

    private PerformanceInsightsMetricsDetail(BuilderImpl builder) {
        this.metricDisplayName = builder.metricDisplayName;
        this.unit = builder.unit;
        this.metricQuery = builder.metricQuery;
        this.referenceData = builder.referenceData;
        this.statsAtAnomaly = builder.statsAtAnomaly;
        this.statsAtBaseline = builder.statsAtBaseline;
    }

    public final String metricDisplayName() {
        return this.metricDisplayName;
    }

    public final String unit() {
        return this.unit;
    }

    public final PerformanceInsightsMetricQuery metricQuery() {
        return this.metricQuery;
    }

    public final boolean hasReferenceData() {
        return this.referenceData != null && !(this.referenceData instanceof SdkAutoConstructList);
    }

    public final List<PerformanceInsightsReferenceData> referenceData() {
        return this.referenceData;
    }

    public final boolean hasStatsAtAnomaly() {
        return this.statsAtAnomaly != null && !(this.statsAtAnomaly instanceof SdkAutoConstructList);
    }

    public final List<PerformanceInsightsStat> statsAtAnomaly() {
        return this.statsAtAnomaly;
    }

    public final boolean hasStatsAtBaseline() {
        return this.statsAtBaseline != null && !(this.statsAtBaseline instanceof SdkAutoConstructList);
    }

    public final List<PerformanceInsightsStat> statsAtBaseline() {
        return this.statsAtBaseline;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.metricDisplayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.unit());
        hashCode = 31 * hashCode + Objects.hashCode(this.metricQuery());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReferenceData() ? this.referenceData() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStatsAtAnomaly() ? this.statsAtAnomaly() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStatsAtBaseline() ? this.statsAtBaseline() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PerformanceInsightsMetricsDetail)) {
            return false;
        }
        PerformanceInsightsMetricsDetail other = (PerformanceInsightsMetricsDetail)obj;
        return Objects.equals(this.metricDisplayName(), other.metricDisplayName()) && Objects.equals(this.unit(), other.unit()) && Objects.equals(this.metricQuery(), other.metricQuery()) && this.hasReferenceData() == other.hasReferenceData() && Objects.equals(this.referenceData(), other.referenceData()) && this.hasStatsAtAnomaly() == other.hasStatsAtAnomaly() && Objects.equals(this.statsAtAnomaly(), other.statsAtAnomaly()) && this.hasStatsAtBaseline() == other.hasStatsAtBaseline() && Objects.equals(this.statsAtBaseline(), other.statsAtBaseline());
    }

    public final String toString() {
        return ToString.builder((String)"PerformanceInsightsMetricsDetail").add("MetricDisplayName", (Object)this.metricDisplayName()).add("Unit", (Object)this.unit()).add("MetricQuery", (Object)this.metricQuery()).add("ReferenceData", this.hasReferenceData() ? this.referenceData() : null).add("StatsAtAnomaly", this.hasStatsAtAnomaly() ? this.statsAtAnomaly() : null).add("StatsAtBaseline", this.hasStatsAtBaseline() ? this.statsAtBaseline() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MetricDisplayName": {
                return Optional.ofNullable(clazz.cast(this.metricDisplayName()));
            }
            case "Unit": {
                return Optional.ofNullable(clazz.cast(this.unit()));
            }
            case "MetricQuery": {
                return Optional.ofNullable(clazz.cast(this.metricQuery()));
            }
            case "ReferenceData": {
                return Optional.ofNullable(clazz.cast(this.referenceData()));
            }
            case "StatsAtAnomaly": {
                return Optional.ofNullable(clazz.cast(this.statsAtAnomaly()));
            }
            case "StatsAtBaseline": {
                return Optional.ofNullable(clazz.cast(this.statsAtBaseline()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("MetricDisplayName", METRIC_DISPLAY_NAME_FIELD);
        map.put("Unit", UNIT_FIELD);
        map.put("MetricQuery", METRIC_QUERY_FIELD);
        map.put("ReferenceData", REFERENCE_DATA_FIELD);
        map.put("StatsAtAnomaly", STATS_AT_ANOMALY_FIELD);
        map.put("StatsAtBaseline", STATS_AT_BASELINE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PerformanceInsightsMetricsDetail, T> g) {
        return obj -> g.apply((PerformanceInsightsMetricsDetail)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String metricDisplayName;
        private String unit;
        private PerformanceInsightsMetricQuery metricQuery;
        private List<PerformanceInsightsReferenceData> referenceData = DefaultSdkAutoConstructList.getInstance();
        private List<PerformanceInsightsStat> statsAtAnomaly = DefaultSdkAutoConstructList.getInstance();
        private List<PerformanceInsightsStat> statsAtBaseline = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PerformanceInsightsMetricsDetail model) {
            this.metricDisplayName(model.metricDisplayName);
            this.unit(model.unit);
            this.metricQuery(model.metricQuery);
            this.referenceData(model.referenceData);
            this.statsAtAnomaly(model.statsAtAnomaly);
            this.statsAtBaseline(model.statsAtBaseline);
        }

        public final String getMetricDisplayName() {
            return this.metricDisplayName;
        }

        public final void setMetricDisplayName(String metricDisplayName) {
            this.metricDisplayName = metricDisplayName;
        }

        @Override
        public final Builder metricDisplayName(String metricDisplayName) {
            this.metricDisplayName = metricDisplayName;
            return this;
        }

        public final String getUnit() {
            return this.unit;
        }

        public final void setUnit(String unit) {
            this.unit = unit;
        }

        @Override
        public final Builder unit(String unit) {
            this.unit = unit;
            return this;
        }

        public final PerformanceInsightsMetricQuery.Builder getMetricQuery() {
            return this.metricQuery != null ? this.metricQuery.toBuilder() : null;
        }

        public final void setMetricQuery(PerformanceInsightsMetricQuery.BuilderImpl metricQuery) {
            this.metricQuery = metricQuery != null ? metricQuery.build() : null;
        }

        @Override
        public final Builder metricQuery(PerformanceInsightsMetricQuery metricQuery) {
            this.metricQuery = metricQuery;
            return this;
        }

        public final List<PerformanceInsightsReferenceData.Builder> getReferenceData() {
            List<PerformanceInsightsReferenceData.Builder> result = PerformanceInsightsReferenceDataListCopier.copyToBuilder(this.referenceData);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setReferenceData(Collection<PerformanceInsightsReferenceData.BuilderImpl> referenceData) {
            this.referenceData = PerformanceInsightsReferenceDataListCopier.copyFromBuilder(referenceData);
        }

        @Override
        public final Builder referenceData(Collection<PerformanceInsightsReferenceData> referenceData) {
            this.referenceData = PerformanceInsightsReferenceDataListCopier.copy(referenceData);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder referenceData(PerformanceInsightsReferenceData ... referenceData) {
            this.referenceData(Arrays.asList(referenceData));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder referenceData(Consumer<PerformanceInsightsReferenceData.Builder> ... referenceData) {
            this.referenceData(Stream.of(referenceData).map(c -> (PerformanceInsightsReferenceData)((PerformanceInsightsReferenceData.Builder)PerformanceInsightsReferenceData.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<PerformanceInsightsStat.Builder> getStatsAtAnomaly() {
            List<PerformanceInsightsStat.Builder> result = PerformanceInsightsStatsCopier.copyToBuilder(this.statsAtAnomaly);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStatsAtAnomaly(Collection<PerformanceInsightsStat.BuilderImpl> statsAtAnomaly) {
            this.statsAtAnomaly = PerformanceInsightsStatsCopier.copyFromBuilder(statsAtAnomaly);
        }

        @Override
        public final Builder statsAtAnomaly(Collection<PerformanceInsightsStat> statsAtAnomaly) {
            this.statsAtAnomaly = PerformanceInsightsStatsCopier.copy(statsAtAnomaly);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statsAtAnomaly(PerformanceInsightsStat ... statsAtAnomaly) {
            this.statsAtAnomaly(Arrays.asList(statsAtAnomaly));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statsAtAnomaly(Consumer<PerformanceInsightsStat.Builder> ... statsAtAnomaly) {
            this.statsAtAnomaly(Stream.of(statsAtAnomaly).map(c -> (PerformanceInsightsStat)((PerformanceInsightsStat.Builder)PerformanceInsightsStat.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<PerformanceInsightsStat.Builder> getStatsAtBaseline() {
            List<PerformanceInsightsStat.Builder> result = PerformanceInsightsStatsCopier.copyToBuilder(this.statsAtBaseline);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStatsAtBaseline(Collection<PerformanceInsightsStat.BuilderImpl> statsAtBaseline) {
            this.statsAtBaseline = PerformanceInsightsStatsCopier.copyFromBuilder(statsAtBaseline);
        }

        @Override
        public final Builder statsAtBaseline(Collection<PerformanceInsightsStat> statsAtBaseline) {
            this.statsAtBaseline = PerformanceInsightsStatsCopier.copy(statsAtBaseline);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statsAtBaseline(PerformanceInsightsStat ... statsAtBaseline) {
            this.statsAtBaseline(Arrays.asList(statsAtBaseline));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statsAtBaseline(Consumer<PerformanceInsightsStat.Builder> ... statsAtBaseline) {
            this.statsAtBaseline(Stream.of(statsAtBaseline).map(c -> (PerformanceInsightsStat)((PerformanceInsightsStat.Builder)PerformanceInsightsStat.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public PerformanceInsightsMetricsDetail build() {
            return new PerformanceInsightsMetricsDetail(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PerformanceInsightsMetricsDetail> {
        public Builder metricDisplayName(String var1);

        public Builder unit(String var1);

        public Builder metricQuery(PerformanceInsightsMetricQuery var1);

        default public Builder metricQuery(Consumer<PerformanceInsightsMetricQuery.Builder> metricQuery) {
            return this.metricQuery((PerformanceInsightsMetricQuery)((PerformanceInsightsMetricQuery.Builder)PerformanceInsightsMetricQuery.builder().applyMutation(metricQuery)).build());
        }

        public Builder referenceData(Collection<PerformanceInsightsReferenceData> var1);

        public Builder referenceData(PerformanceInsightsReferenceData ... var1);

        public Builder referenceData(Consumer<PerformanceInsightsReferenceData.Builder> ... var1);

        public Builder statsAtAnomaly(Collection<PerformanceInsightsStat> var1);

        public Builder statsAtAnomaly(PerformanceInsightsStat ... var1);

        public Builder statsAtAnomaly(Consumer<PerformanceInsightsStat.Builder> ... var1);

        public Builder statsAtBaseline(Collection<PerformanceInsightsStat> var1);

        public Builder statsAtBaseline(PerformanceInsightsStat ... var1);

        public Builder statsAtBaseline(Consumer<PerformanceInsightsStat.Builder> ... var1);
    }
}

