/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devopsguru.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum EventClass {
    INFRASTRUCTURE("INFRASTRUCTURE"),
    DEPLOYMENT("DEPLOYMENT"),
    SECURITY_CHANGE("SECURITY_CHANGE"),
    CONFIG_CHANGE("CONFIG_CHANGE"),
    SCHEMA_CHANGE("SCHEMA_CHANGE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, EventClass> VALUE_MAP;
    private final String value;

    private EventClass(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static EventClass fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<EventClass> knownValues() {
        EnumSet<EventClass> knownValues = EnumSet.allOf(EventClass.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(EventClass.class, EventClass::toString);
    }
}

