/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devopsguru.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.devopsguru.model.UpdateTagValuesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateTagCollectionFilter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, UpdateTagCollectionFilter> {
    private static final SdkField<String> APP_BOUNDARY_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AppBoundaryKey").getter(UpdateTagCollectionFilter.getter(UpdateTagCollectionFilter::appBoundaryKey)).setter(UpdateTagCollectionFilter.setter(Builder::appBoundaryKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppBoundaryKey").build()}).build();
    private static final SdkField<List<String>> TAG_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TagValues").getter(UpdateTagCollectionFilter.getter(UpdateTagCollectionFilter::tagValues)).setter(UpdateTagCollectionFilter.setter(Builder::tagValues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagValues").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_BOUNDARY_KEY_FIELD, TAG_VALUES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateTagCollectionFilter.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String appBoundaryKey;
    private final List<String> tagValues;

    private UpdateTagCollectionFilter(BuilderImpl builder) {
        this.appBoundaryKey = builder.appBoundaryKey;
        this.tagValues = builder.tagValues;
    }

    public final String appBoundaryKey() {
        return this.appBoundaryKey;
    }

    public final boolean hasTagValues() {
        return this.tagValues != null && !(this.tagValues instanceof SdkAutoConstructList);
    }

    public final List<String> tagValues() {
        return this.tagValues;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.appBoundaryKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTagValues() ? this.tagValues() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateTagCollectionFilter)) {
            return false;
        }
        UpdateTagCollectionFilter other = (UpdateTagCollectionFilter)obj;
        return Objects.equals(this.appBoundaryKey(), other.appBoundaryKey()) && this.hasTagValues() == other.hasTagValues() && Objects.equals(this.tagValues(), other.tagValues());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateTagCollectionFilter").add("AppBoundaryKey", (Object)this.appBoundaryKey()).add("TagValues", this.hasTagValues() ? this.tagValues() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AppBoundaryKey": {
                return Optional.ofNullable(clazz.cast(this.appBoundaryKey()));
            }
            case "TagValues": {
                return Optional.ofNullable(clazz.cast(this.tagValues()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AppBoundaryKey", APP_BOUNDARY_KEY_FIELD);
        map.put("TagValues", TAG_VALUES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateTagCollectionFilter, T> g) {
        return obj -> g.apply((UpdateTagCollectionFilter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String appBoundaryKey;
        private List<String> tagValues = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateTagCollectionFilter model) {
            this.appBoundaryKey(model.appBoundaryKey);
            this.tagValues(model.tagValues);
        }

        public final String getAppBoundaryKey() {
            return this.appBoundaryKey;
        }

        public final void setAppBoundaryKey(String appBoundaryKey) {
            this.appBoundaryKey = appBoundaryKey;
        }

        @Override
        public final Builder appBoundaryKey(String appBoundaryKey) {
            this.appBoundaryKey = appBoundaryKey;
            return this;
        }

        public final Collection<String> getTagValues() {
            if (this.tagValues instanceof SdkAutoConstructList) {
                return null;
            }
            return this.tagValues;
        }

        public final void setTagValues(Collection<String> tagValues) {
            this.tagValues = UpdateTagValuesCopier.copy(tagValues);
        }

        @Override
        public final Builder tagValues(Collection<String> tagValues) {
            this.tagValues = UpdateTagValuesCopier.copy(tagValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagValues(String ... tagValues) {
            this.tagValues(Arrays.asList(tagValues));
            return this;
        }

        public UpdateTagCollectionFilter build() {
            return new UpdateTagCollectionFilter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, UpdateTagCollectionFilter> {
        public Builder appBoundaryKey(String var1);

        public Builder tagValues(Collection<String> var1);

        public Builder tagValues(String ... var1);
    }
}

