/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devopsguru.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.devopsguru.model.DevOpsGuruResponse;
import software.amazon.awssdk.services.devopsguru.model.ProactiveAnomaliesCopier;
import software.amazon.awssdk.services.devopsguru.model.ProactiveAnomalySummary;
import software.amazon.awssdk.services.devopsguru.model.ReactiveAnomaliesCopier;
import software.amazon.awssdk.services.devopsguru.model.ReactiveAnomalySummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAnomaliesForInsightResponse
extends DevOpsGuruResponse
implements ToCopyableBuilder<Builder, ListAnomaliesForInsightResponse> {
    private static final SdkField<List<ProactiveAnomalySummary>> PROACTIVE_ANOMALIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ProactiveAnomalies").getter(ListAnomaliesForInsightResponse.getter(ListAnomaliesForInsightResponse::proactiveAnomalies)).setter(ListAnomaliesForInsightResponse.setter(Builder::proactiveAnomalies)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProactiveAnomalies").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ProactiveAnomalySummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ReactiveAnomalySummary>> REACTIVE_ANOMALIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ReactiveAnomalies").getter(ListAnomaliesForInsightResponse.getter(ListAnomaliesForInsightResponse::reactiveAnomalies)).setter(ListAnomaliesForInsightResponse.setter(Builder::reactiveAnomalies)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReactiveAnomalies").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ReactiveAnomalySummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListAnomaliesForInsightResponse.getter(ListAnomaliesForInsightResponse::nextToken)).setter(ListAnomaliesForInsightResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROACTIVE_ANOMALIES_FIELD, REACTIVE_ANOMALIES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListAnomaliesForInsightResponse.memberNameToFieldInitializer();
    private final List<ProactiveAnomalySummary> proactiveAnomalies;
    private final List<ReactiveAnomalySummary> reactiveAnomalies;
    private final String nextToken;

    private ListAnomaliesForInsightResponse(BuilderImpl builder) {
        super(builder);
        this.proactiveAnomalies = builder.proactiveAnomalies;
        this.reactiveAnomalies = builder.reactiveAnomalies;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasProactiveAnomalies() {
        return this.proactiveAnomalies != null && !(this.proactiveAnomalies instanceof SdkAutoConstructList);
    }

    public final List<ProactiveAnomalySummary> proactiveAnomalies() {
        return this.proactiveAnomalies;
    }

    public final boolean hasReactiveAnomalies() {
        return this.reactiveAnomalies != null && !(this.reactiveAnomalies instanceof SdkAutoConstructList);
    }

    public final List<ReactiveAnomalySummary> reactiveAnomalies() {
        return this.reactiveAnomalies;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProactiveAnomalies() ? this.proactiveAnomalies() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReactiveAnomalies() ? this.reactiveAnomalies() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAnomaliesForInsightResponse)) {
            return false;
        }
        ListAnomaliesForInsightResponse other = (ListAnomaliesForInsightResponse)((Object)obj);
        return this.hasProactiveAnomalies() == other.hasProactiveAnomalies() && Objects.equals(this.proactiveAnomalies(), other.proactiveAnomalies()) && this.hasReactiveAnomalies() == other.hasReactiveAnomalies() && Objects.equals(this.reactiveAnomalies(), other.reactiveAnomalies()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListAnomaliesForInsightResponse").add("ProactiveAnomalies", this.hasProactiveAnomalies() ? this.proactiveAnomalies() : null).add("ReactiveAnomalies", this.hasReactiveAnomalies() ? this.reactiveAnomalies() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProactiveAnomalies": {
                return Optional.ofNullable(clazz.cast(this.proactiveAnomalies()));
            }
            case "ReactiveAnomalies": {
                return Optional.ofNullable(clazz.cast(this.reactiveAnomalies()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ProactiveAnomalies", PROACTIVE_ANOMALIES_FIELD);
        map.put("ReactiveAnomalies", REACTIVE_ANOMALIES_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListAnomaliesForInsightResponse, T> g) {
        return obj -> g.apply((ListAnomaliesForInsightResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DevOpsGuruResponse.BuilderImpl
    implements Builder {
        private List<ProactiveAnomalySummary> proactiveAnomalies = DefaultSdkAutoConstructList.getInstance();
        private List<ReactiveAnomalySummary> reactiveAnomalies = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAnomaliesForInsightResponse model) {
            super(model);
            this.proactiveAnomalies(model.proactiveAnomalies);
            this.reactiveAnomalies(model.reactiveAnomalies);
            this.nextToken(model.nextToken);
        }

        public final List<ProactiveAnomalySummary.Builder> getProactiveAnomalies() {
            List<ProactiveAnomalySummary.Builder> result = ProactiveAnomaliesCopier.copyToBuilder(this.proactiveAnomalies);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProactiveAnomalies(Collection<ProactiveAnomalySummary.BuilderImpl> proactiveAnomalies) {
            this.proactiveAnomalies = ProactiveAnomaliesCopier.copyFromBuilder(proactiveAnomalies);
        }

        @Override
        public final Builder proactiveAnomalies(Collection<ProactiveAnomalySummary> proactiveAnomalies) {
            this.proactiveAnomalies = ProactiveAnomaliesCopier.copy(proactiveAnomalies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder proactiveAnomalies(ProactiveAnomalySummary ... proactiveAnomalies) {
            this.proactiveAnomalies(Arrays.asList(proactiveAnomalies));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder proactiveAnomalies(Consumer<ProactiveAnomalySummary.Builder> ... proactiveAnomalies) {
            this.proactiveAnomalies(Stream.of(proactiveAnomalies).map(c -> (ProactiveAnomalySummary)((ProactiveAnomalySummary.Builder)ProactiveAnomalySummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ReactiveAnomalySummary.Builder> getReactiveAnomalies() {
            List<ReactiveAnomalySummary.Builder> result = ReactiveAnomaliesCopier.copyToBuilder(this.reactiveAnomalies);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setReactiveAnomalies(Collection<ReactiveAnomalySummary.BuilderImpl> reactiveAnomalies) {
            this.reactiveAnomalies = ReactiveAnomaliesCopier.copyFromBuilder(reactiveAnomalies);
        }

        @Override
        public final Builder reactiveAnomalies(Collection<ReactiveAnomalySummary> reactiveAnomalies) {
            this.reactiveAnomalies = ReactiveAnomaliesCopier.copy(reactiveAnomalies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reactiveAnomalies(ReactiveAnomalySummary ... reactiveAnomalies) {
            this.reactiveAnomalies(Arrays.asList(reactiveAnomalies));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reactiveAnomalies(Consumer<ReactiveAnomalySummary.Builder> ... reactiveAnomalies) {
            this.reactiveAnomalies(Stream.of(reactiveAnomalies).map(c -> (ReactiveAnomalySummary)((ReactiveAnomalySummary.Builder)ReactiveAnomalySummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListAnomaliesForInsightResponse build() {
            return new ListAnomaliesForInsightResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends DevOpsGuruResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListAnomaliesForInsightResponse> {
        public Builder proactiveAnomalies(Collection<ProactiveAnomalySummary> var1);

        public Builder proactiveAnomalies(ProactiveAnomalySummary ... var1);

        public Builder proactiveAnomalies(Consumer<ProactiveAnomalySummary.Builder> ... var1);

        public Builder reactiveAnomalies(Collection<ReactiveAnomalySummary> var1);

        public Builder reactiveAnomalies(ReactiveAnomalySummary ... var1);

        public Builder reactiveAnomalies(Consumer<ReactiveAnomalySummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

