/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devopsguru.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.devopsguru.DevOpsGuruAsyncClient;
import software.amazon.awssdk.services.devopsguru.internal.UserAgentUtils;
import software.amazon.awssdk.services.devopsguru.model.ListOrganizationInsightsRequest;
import software.amazon.awssdk.services.devopsguru.model.ListOrganizationInsightsResponse;
import software.amazon.awssdk.services.devopsguru.model.ProactiveOrganizationInsightSummary;
import software.amazon.awssdk.services.devopsguru.model.ReactiveOrganizationInsightSummary;

public class ListOrganizationInsightsPublisher
implements SdkPublisher<ListOrganizationInsightsResponse> {
    private final DevOpsGuruAsyncClient client;
    private final ListOrganizationInsightsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListOrganizationInsightsPublisher(DevOpsGuruAsyncClient client, ListOrganizationInsightsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListOrganizationInsightsPublisher(DevOpsGuruAsyncClient client, ListOrganizationInsightsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListOrganizationInsightsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListOrganizationInsightsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ProactiveOrganizationInsightSummary> proactiveInsights() {
        Function<ListOrganizationInsightsResponse, Iterator> getIterator = response -> {
            if (response != null && response.proactiveInsights() != null) {
                return response.proactiveInsights().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListOrganizationInsightsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    public final SdkPublisher<ReactiveOrganizationInsightSummary> reactiveInsights() {
        Function<ListOrganizationInsightsResponse, Iterator> getIterator = response -> {
            if (response != null && response.reactiveInsights() != null) {
                return response.reactiveInsights().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListOrganizationInsightsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListOrganizationInsightsResponseFetcher
    implements AsyncPageFetcher<ListOrganizationInsightsResponse> {
        private ListOrganizationInsightsResponseFetcher() {
        }

        public boolean hasNextPage(ListOrganizationInsightsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListOrganizationInsightsResponse> nextPage(ListOrganizationInsightsResponse previousPage) {
            if (previousPage == null) {
                return ListOrganizationInsightsPublisher.this.client.listOrganizationInsights(ListOrganizationInsightsPublisher.this.firstRequest);
            }
            return ListOrganizationInsightsPublisher.this.client.listOrganizationInsights((ListOrganizationInsightsRequest)((Object)ListOrganizationInsightsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

