/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devopsguru.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.devopsguru.DevOpsGuruAsyncClient;
import software.amazon.awssdk.services.devopsguru.internal.UserAgentUtils;
import software.amazon.awssdk.services.devopsguru.model.Event;
import software.amazon.awssdk.services.devopsguru.model.ListEventsRequest;
import software.amazon.awssdk.services.devopsguru.model.ListEventsResponse;

public class ListEventsPublisher
implements SdkPublisher<ListEventsResponse> {
    private final DevOpsGuruAsyncClient client;
    private final ListEventsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListEventsPublisher(DevOpsGuruAsyncClient client, ListEventsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListEventsPublisher(DevOpsGuruAsyncClient client, ListEventsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListEventsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListEventsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Event> events() {
        Function<ListEventsResponse, Iterator> getIterator = response -> {
            if (response != null && response.events() != null) {
                return response.events().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListEventsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListEventsResponseFetcher
    implements AsyncPageFetcher<ListEventsResponse> {
        private ListEventsResponseFetcher() {
        }

        public boolean hasNextPage(ListEventsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListEventsResponse> nextPage(ListEventsResponse previousPage) {
            if (previousPage == null) {
                return ListEventsPublisher.this.client.listEvents(ListEventsPublisher.this.firstRequest);
            }
            return ListEventsPublisher.this.client.listEvents((ListEventsRequest)((Object)ListEventsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

