/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devopsguru.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.devopsguru.model.InsightSeveritiesCopier;
import software.amazon.awssdk.services.devopsguru.model.InsightSeverity;
import software.amazon.awssdk.services.devopsguru.model.NotificationMessageType;
import software.amazon.awssdk.services.devopsguru.model.NotificationMessageTypesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NotificationFilterConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, NotificationFilterConfig> {
    private static final SdkField<List<String>> SEVERITIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Severities").getter(NotificationFilterConfig.getter(NotificationFilterConfig::severitiesAsStrings)).setter(NotificationFilterConfig.setter(Builder::severitiesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Severities").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> MESSAGE_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MessageTypes").getter(NotificationFilterConfig.getter(NotificationFilterConfig::messageTypesAsStrings)).setter(NotificationFilterConfig.setter(Builder::messageTypesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MessageTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SEVERITIES_FIELD, MESSAGE_TYPES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = NotificationFilterConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> severities;
    private final List<String> messageTypes;

    private NotificationFilterConfig(BuilderImpl builder) {
        this.severities = builder.severities;
        this.messageTypes = builder.messageTypes;
    }

    public final List<InsightSeverity> severities() {
        return InsightSeveritiesCopier.copyStringToEnum(this.severities);
    }

    public final boolean hasSeverities() {
        return this.severities != null && !(this.severities instanceof SdkAutoConstructList);
    }

    public final List<String> severitiesAsStrings() {
        return this.severities;
    }

    public final List<NotificationMessageType> messageTypes() {
        return NotificationMessageTypesCopier.copyStringToEnum(this.messageTypes);
    }

    public final boolean hasMessageTypes() {
        return this.messageTypes != null && !(this.messageTypes instanceof SdkAutoConstructList);
    }

    public final List<String> messageTypesAsStrings() {
        return this.messageTypes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSeverities() ? this.severitiesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMessageTypes() ? this.messageTypesAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NotificationFilterConfig)) {
            return false;
        }
        NotificationFilterConfig other = (NotificationFilterConfig)obj;
        return this.hasSeverities() == other.hasSeverities() && Objects.equals(this.severitiesAsStrings(), other.severitiesAsStrings()) && this.hasMessageTypes() == other.hasMessageTypes() && Objects.equals(this.messageTypesAsStrings(), other.messageTypesAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"NotificationFilterConfig").add("Severities", this.hasSeverities() ? this.severitiesAsStrings() : null).add("MessageTypes", this.hasMessageTypes() ? this.messageTypesAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Severities": {
                return Optional.ofNullable(clazz.cast(this.severitiesAsStrings()));
            }
            case "MessageTypes": {
                return Optional.ofNullable(clazz.cast(this.messageTypesAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<String>>> map = new HashMap<String, SdkField<List<String>>>();
        map.put("Severities", SEVERITIES_FIELD);
        map.put("MessageTypes", MESSAGE_TYPES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<NotificationFilterConfig, T> g) {
        return obj -> g.apply((NotificationFilterConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> severities = DefaultSdkAutoConstructList.getInstance();
        private List<String> messageTypes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(NotificationFilterConfig model) {
            this.severitiesWithStrings(model.severities);
            this.messageTypesWithStrings(model.messageTypes);
        }

        public final Collection<String> getSeverities() {
            if (this.severities instanceof SdkAutoConstructList) {
                return null;
            }
            return this.severities;
        }

        public final void setSeverities(Collection<String> severities) {
            this.severities = InsightSeveritiesCopier.copy(severities);
        }

        @Override
        public final Builder severitiesWithStrings(Collection<String> severities) {
            this.severities = InsightSeveritiesCopier.copy(severities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder severitiesWithStrings(String ... severities) {
            this.severitiesWithStrings(Arrays.asList(severities));
            return this;
        }

        @Override
        public final Builder severities(Collection<InsightSeverity> severities) {
            this.severities = InsightSeveritiesCopier.copyEnumToString(severities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder severities(InsightSeverity ... severities) {
            this.severities(Arrays.asList(severities));
            return this;
        }

        public final Collection<String> getMessageTypes() {
            if (this.messageTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.messageTypes;
        }

        public final void setMessageTypes(Collection<String> messageTypes) {
            this.messageTypes = NotificationMessageTypesCopier.copy(messageTypes);
        }

        @Override
        public final Builder messageTypesWithStrings(Collection<String> messageTypes) {
            this.messageTypes = NotificationMessageTypesCopier.copy(messageTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder messageTypesWithStrings(String ... messageTypes) {
            this.messageTypesWithStrings(Arrays.asList(messageTypes));
            return this;
        }

        @Override
        public final Builder messageTypes(Collection<NotificationMessageType> messageTypes) {
            this.messageTypes = NotificationMessageTypesCopier.copyEnumToString(messageTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder messageTypes(NotificationMessageType ... messageTypes) {
            this.messageTypes(Arrays.asList(messageTypes));
            return this;
        }

        public NotificationFilterConfig build() {
            return new NotificationFilterConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, NotificationFilterConfig> {
        public Builder severitiesWithStrings(Collection<String> var1);

        public Builder severitiesWithStrings(String ... var1);

        public Builder severities(Collection<InsightSeverity> var1);

        public Builder severities(InsightSeverity ... var1);

        public Builder messageTypesWithStrings(Collection<String> var1);

        public Builder messageTypesWithStrings(String ... var1);

        public Builder messageTypes(Collection<NotificationMessageType> var1);

        public Builder messageTypes(NotificationMessageType ... var1);
    }
}

