/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devopsguru.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ResourcePermission {
    FULL_PERMISSION("FULL_PERMISSION"),
    MISSING_PERMISSION("MISSING_PERMISSION"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ResourcePermission> VALUE_MAP;
    private final String value;

    private ResourcePermission(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ResourcePermission fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ResourcePermission> knownValues() {
        EnumSet<ResourcePermission> knownValues = EnumSet.allOf(ResourcePermission.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ResourcePermission.class, ResourcePermission::toString);
    }
}

