/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devopsguru.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ResourceTypeFilter {
    LOG_GROUPS("LOG_GROUPS"),
    CLOUDFRONT_DISTRIBUTION("CLOUDFRONT_DISTRIBUTION"),
    DYNAMODB_TABLE("DYNAMODB_TABLE"),
    EC2_NAT_GATEWAY("EC2_NAT_GATEWAY"),
    ECS_CLUSTER("ECS_CLUSTER"),
    ECS_SERVICE("ECS_SERVICE"),
    EKS_CLUSTER("EKS_CLUSTER"),
    ELASTIC_BEANSTALK_ENVIRONMENT("ELASTIC_BEANSTALK_ENVIRONMENT"),
    ELASTIC_LOAD_BALANCER_LOAD_BALANCER("ELASTIC_LOAD_BALANCER_LOAD_BALANCER"),
    ELASTIC_LOAD_BALANCING_V2_LOAD_BALANCER("ELASTIC_LOAD_BALANCING_V2_LOAD_BALANCER"),
    ELASTIC_LOAD_BALANCING_V2_TARGET_GROUP("ELASTIC_LOAD_BALANCING_V2_TARGET_GROUP"),
    ELASTICACHE_CACHE_CLUSTER("ELASTICACHE_CACHE_CLUSTER"),
    ELASTICSEARCH_DOMAIN("ELASTICSEARCH_DOMAIN"),
    KINESIS_STREAM("KINESIS_STREAM"),
    LAMBDA_FUNCTION("LAMBDA_FUNCTION"),
    OPEN_SEARCH_SERVICE_DOMAIN("OPEN_SEARCH_SERVICE_DOMAIN"),
    RDS_DB_INSTANCE("RDS_DB_INSTANCE"),
    RDS_DB_CLUSTER("RDS_DB_CLUSTER"),
    REDSHIFT_CLUSTER("REDSHIFT_CLUSTER"),
    ROUTE53_HOSTED_ZONE("ROUTE53_HOSTED_ZONE"),
    ROUTE53_HEALTH_CHECK("ROUTE53_HEALTH_CHECK"),
    S3_BUCKET("S3_BUCKET"),
    SAGEMAKER_ENDPOINT("SAGEMAKER_ENDPOINT"),
    SNS_TOPIC("SNS_TOPIC"),
    SQS_QUEUE("SQS_QUEUE"),
    STEP_FUNCTIONS_ACTIVITY("STEP_FUNCTIONS_ACTIVITY"),
    STEP_FUNCTIONS_STATE_MACHINE("STEP_FUNCTIONS_STATE_MACHINE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ResourceTypeFilter> VALUE_MAP;
    private final String value;

    private ResourceTypeFilter(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ResourceTypeFilter fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ResourceTypeFilter> knownValues() {
        EnumSet<ResourceTypeFilter> knownValues = EnumSet.allOf(ResourceTypeFilter.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ResourceTypeFilter.class, ResourceTypeFilter::toString);
    }
}

