/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devopsguru.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ServerSideEncryptionType {
    CUSTOMER_MANAGED_KEY("CUSTOMER_MANAGED_KEY"),
    AWS_OWNED_KMS_KEY("AWS_OWNED_KMS_KEY"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ServerSideEncryptionType> VALUE_MAP;
    private final String value;

    private ServerSideEncryptionType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ServerSideEncryptionType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ServerSideEncryptionType> knownValues() {
        EnumSet<ServerSideEncryptionType> knownValues = EnumSet.allOf(ServerSideEncryptionType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ServerSideEncryptionType.class, ServerSideEncryptionType::toString);
    }
}

