/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devopsguru.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.devopsguru.model.InsightSeveritiesCopier;
import software.amazon.awssdk.services.devopsguru.model.InsightSeverity;
import software.amazon.awssdk.services.devopsguru.model.InsightStatus;
import software.amazon.awssdk.services.devopsguru.model.InsightStatusesCopier;
import software.amazon.awssdk.services.devopsguru.model.ResourceCollection;
import software.amazon.awssdk.services.devopsguru.model.ServiceCollection;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SearchOrganizationInsightsFilters
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SearchOrganizationInsightsFilters> {
    private static final SdkField<List<String>> SEVERITIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Severities").getter(SearchOrganizationInsightsFilters.getter(SearchOrganizationInsightsFilters::severitiesAsStrings)).setter(SearchOrganizationInsightsFilters.setter(Builder::severitiesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Severities").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> STATUSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Statuses").getter(SearchOrganizationInsightsFilters.getter(SearchOrganizationInsightsFilters::statusesAsStrings)).setter(SearchOrganizationInsightsFilters.setter(Builder::statusesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Statuses").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ResourceCollection> RESOURCE_COLLECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ResourceCollection").getter(SearchOrganizationInsightsFilters.getter(SearchOrganizationInsightsFilters::resourceCollection)).setter(SearchOrganizationInsightsFilters.setter(Builder::resourceCollection)).constructor(ResourceCollection::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceCollection").build()}).build();
    private static final SdkField<ServiceCollection> SERVICE_COLLECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ServiceCollection").getter(SearchOrganizationInsightsFilters.getter(SearchOrganizationInsightsFilters::serviceCollection)).setter(SearchOrganizationInsightsFilters.setter(Builder::serviceCollection)).constructor(ServiceCollection::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceCollection").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SEVERITIES_FIELD, STATUSES_FIELD, RESOURCE_COLLECTION_FIELD, SERVICE_COLLECTION_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> severities;
    private final List<String> statuses;
    private final ResourceCollection resourceCollection;
    private final ServiceCollection serviceCollection;

    private SearchOrganizationInsightsFilters(BuilderImpl builder) {
        this.severities = builder.severities;
        this.statuses = builder.statuses;
        this.resourceCollection = builder.resourceCollection;
        this.serviceCollection = builder.serviceCollection;
    }

    public final List<InsightSeverity> severities() {
        return InsightSeveritiesCopier.copyStringToEnum(this.severities);
    }

    public final boolean hasSeverities() {
        return this.severities != null && !(this.severities instanceof SdkAutoConstructList);
    }

    public final List<String> severitiesAsStrings() {
        return this.severities;
    }

    public final List<InsightStatus> statuses() {
        return InsightStatusesCopier.copyStringToEnum(this.statuses);
    }

    public final boolean hasStatuses() {
        return this.statuses != null && !(this.statuses instanceof SdkAutoConstructList);
    }

    public final List<String> statusesAsStrings() {
        return this.statuses;
    }

    public final ResourceCollection resourceCollection() {
        return this.resourceCollection;
    }

    public final ServiceCollection serviceCollection() {
        return this.serviceCollection;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSeverities() ? this.severitiesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStatuses() ? this.statusesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceCollection());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceCollection());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchOrganizationInsightsFilters)) {
            return false;
        }
        SearchOrganizationInsightsFilters other = (SearchOrganizationInsightsFilters)obj;
        return this.hasSeverities() == other.hasSeverities() && Objects.equals(this.severitiesAsStrings(), other.severitiesAsStrings()) && this.hasStatuses() == other.hasStatuses() && Objects.equals(this.statusesAsStrings(), other.statusesAsStrings()) && Objects.equals(this.resourceCollection(), other.resourceCollection()) && Objects.equals(this.serviceCollection(), other.serviceCollection());
    }

    public final String toString() {
        return ToString.builder((String)"SearchOrganizationInsightsFilters").add("Severities", this.hasSeverities() ? this.severitiesAsStrings() : null).add("Statuses", this.hasStatuses() ? this.statusesAsStrings() : null).add("ResourceCollection", (Object)this.resourceCollection()).add("ServiceCollection", (Object)this.serviceCollection()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Severities": {
                return Optional.ofNullable(clazz.cast(this.severitiesAsStrings()));
            }
            case "Statuses": {
                return Optional.ofNullable(clazz.cast(this.statusesAsStrings()));
            }
            case "ResourceCollection": {
                return Optional.ofNullable(clazz.cast(this.resourceCollection()));
            }
            case "ServiceCollection": {
                return Optional.ofNullable(clazz.cast(this.serviceCollection()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SearchOrganizationInsightsFilters, T> g) {
        return obj -> g.apply((SearchOrganizationInsightsFilters)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> severities = DefaultSdkAutoConstructList.getInstance();
        private List<String> statuses = DefaultSdkAutoConstructList.getInstance();
        private ResourceCollection resourceCollection;
        private ServiceCollection serviceCollection;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchOrganizationInsightsFilters model) {
            this.severitiesWithStrings(model.severities);
            this.statusesWithStrings(model.statuses);
            this.resourceCollection(model.resourceCollection);
            this.serviceCollection(model.serviceCollection);
        }

        public final Collection<String> getSeverities() {
            if (this.severities instanceof SdkAutoConstructList) {
                return null;
            }
            return this.severities;
        }

        public final void setSeverities(Collection<String> severities) {
            this.severities = InsightSeveritiesCopier.copy(severities);
        }

        @Override
        public final Builder severitiesWithStrings(Collection<String> severities) {
            this.severities = InsightSeveritiesCopier.copy(severities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder severitiesWithStrings(String ... severities) {
            this.severitiesWithStrings(Arrays.asList(severities));
            return this;
        }

        @Override
        public final Builder severities(Collection<InsightSeverity> severities) {
            this.severities = InsightSeveritiesCopier.copyEnumToString(severities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder severities(InsightSeverity ... severities) {
            this.severities(Arrays.asList(severities));
            return this;
        }

        public final Collection<String> getStatuses() {
            if (this.statuses instanceof SdkAutoConstructList) {
                return null;
            }
            return this.statuses;
        }

        public final void setStatuses(Collection<String> statuses) {
            this.statuses = InsightStatusesCopier.copy(statuses);
        }

        @Override
        public final Builder statusesWithStrings(Collection<String> statuses) {
            this.statuses = InsightStatusesCopier.copy(statuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statusesWithStrings(String ... statuses) {
            this.statusesWithStrings(Arrays.asList(statuses));
            return this;
        }

        @Override
        public final Builder statuses(Collection<InsightStatus> statuses) {
            this.statuses = InsightStatusesCopier.copyEnumToString(statuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statuses(InsightStatus ... statuses) {
            this.statuses(Arrays.asList(statuses));
            return this;
        }

        public final ResourceCollection.Builder getResourceCollection() {
            return this.resourceCollection != null ? this.resourceCollection.toBuilder() : null;
        }

        public final void setResourceCollection(ResourceCollection.BuilderImpl resourceCollection) {
            this.resourceCollection = resourceCollection != null ? resourceCollection.build() : null;
        }

        @Override
        public final Builder resourceCollection(ResourceCollection resourceCollection) {
            this.resourceCollection = resourceCollection;
            return this;
        }

        public final ServiceCollection.Builder getServiceCollection() {
            return this.serviceCollection != null ? this.serviceCollection.toBuilder() : null;
        }

        public final void setServiceCollection(ServiceCollection.BuilderImpl serviceCollection) {
            this.serviceCollection = serviceCollection != null ? serviceCollection.build() : null;
        }

        @Override
        public final Builder serviceCollection(ServiceCollection serviceCollection) {
            this.serviceCollection = serviceCollection;
            return this;
        }

        public SearchOrganizationInsightsFilters build() {
            return new SearchOrganizationInsightsFilters(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SearchOrganizationInsightsFilters> {
        public Builder severitiesWithStrings(Collection<String> var1);

        public Builder severitiesWithStrings(String ... var1);

        public Builder severities(Collection<InsightSeverity> var1);

        public Builder severities(InsightSeverity ... var1);

        public Builder statusesWithStrings(Collection<String> var1);

        public Builder statusesWithStrings(String ... var1);

        public Builder statuses(Collection<InsightStatus> var1);

        public Builder statuses(InsightStatus ... var1);

        public Builder resourceCollection(ResourceCollection var1);

        default public Builder resourceCollection(Consumer<ResourceCollection.Builder> resourceCollection) {
            return this.resourceCollection((ResourceCollection)((ResourceCollection.Builder)ResourceCollection.builder().applyMutation(resourceCollection)).build());
        }

        public Builder serviceCollection(ServiceCollection var1);

        default public Builder serviceCollection(Consumer<ServiceCollection.Builder> serviceCollection) {
            return this.serviceCollection((ServiceCollection)((ServiceCollection.Builder)ServiceCollection.builder().applyMutation(serviceCollection)).build());
        }
    }
}

