/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devopsguru.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.devopsguru.model.DevOpsGuruResponse;
import software.amazon.awssdk.services.devopsguru.model.ProactiveOrganizationInsightSummary;
import software.amazon.awssdk.services.devopsguru.model.ProactiveOrganizationInsightsCopier;
import software.amazon.awssdk.services.devopsguru.model.ReactiveOrganizationInsightSummary;
import software.amazon.awssdk.services.devopsguru.model.ReactiveOrganizationInsightsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListOrganizationInsightsResponse
extends DevOpsGuruResponse
implements ToCopyableBuilder<Builder, ListOrganizationInsightsResponse> {
    private static final SdkField<List<ProactiveOrganizationInsightSummary>> PROACTIVE_INSIGHTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ProactiveInsights").getter(ListOrganizationInsightsResponse.getter(ListOrganizationInsightsResponse::proactiveInsights)).setter(ListOrganizationInsightsResponse.setter(Builder::proactiveInsights)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProactiveInsights").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ProactiveOrganizationInsightSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ReactiveOrganizationInsightSummary>> REACTIVE_INSIGHTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ReactiveInsights").getter(ListOrganizationInsightsResponse.getter(ListOrganizationInsightsResponse::reactiveInsights)).setter(ListOrganizationInsightsResponse.setter(Builder::reactiveInsights)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReactiveInsights").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ReactiveOrganizationInsightSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListOrganizationInsightsResponse.getter(ListOrganizationInsightsResponse::nextToken)).setter(ListOrganizationInsightsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROACTIVE_INSIGHTS_FIELD, REACTIVE_INSIGHTS_FIELD, NEXT_TOKEN_FIELD));
    private final List<ProactiveOrganizationInsightSummary> proactiveInsights;
    private final List<ReactiveOrganizationInsightSummary> reactiveInsights;
    private final String nextToken;

    private ListOrganizationInsightsResponse(BuilderImpl builder) {
        super(builder);
        this.proactiveInsights = builder.proactiveInsights;
        this.reactiveInsights = builder.reactiveInsights;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasProactiveInsights() {
        return this.proactiveInsights != null && !(this.proactiveInsights instanceof SdkAutoConstructList);
    }

    public final List<ProactiveOrganizationInsightSummary> proactiveInsights() {
        return this.proactiveInsights;
    }

    public final boolean hasReactiveInsights() {
        return this.reactiveInsights != null && !(this.reactiveInsights instanceof SdkAutoConstructList);
    }

    public final List<ReactiveOrganizationInsightSummary> reactiveInsights() {
        return this.reactiveInsights;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProactiveInsights() ? this.proactiveInsights() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReactiveInsights() ? this.reactiveInsights() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListOrganizationInsightsResponse)) {
            return false;
        }
        ListOrganizationInsightsResponse other = (ListOrganizationInsightsResponse)((Object)obj);
        return this.hasProactiveInsights() == other.hasProactiveInsights() && Objects.equals(this.proactiveInsights(), other.proactiveInsights()) && this.hasReactiveInsights() == other.hasReactiveInsights() && Objects.equals(this.reactiveInsights(), other.reactiveInsights()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListOrganizationInsightsResponse").add("ProactiveInsights", this.hasProactiveInsights() ? this.proactiveInsights() : null).add("ReactiveInsights", this.hasReactiveInsights() ? this.reactiveInsights() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProactiveInsights": {
                return Optional.ofNullable(clazz.cast(this.proactiveInsights()));
            }
            case "ReactiveInsights": {
                return Optional.ofNullable(clazz.cast(this.reactiveInsights()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListOrganizationInsightsResponse, T> g) {
        return obj -> g.apply((ListOrganizationInsightsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DevOpsGuruResponse.BuilderImpl
    implements Builder {
        private List<ProactiveOrganizationInsightSummary> proactiveInsights = DefaultSdkAutoConstructList.getInstance();
        private List<ReactiveOrganizationInsightSummary> reactiveInsights = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListOrganizationInsightsResponse model) {
            super(model);
            this.proactiveInsights(model.proactiveInsights);
            this.reactiveInsights(model.reactiveInsights);
            this.nextToken(model.nextToken);
        }

        public final List<ProactiveOrganizationInsightSummary.Builder> getProactiveInsights() {
            List<ProactiveOrganizationInsightSummary.Builder> result = ProactiveOrganizationInsightsCopier.copyToBuilder(this.proactiveInsights);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProactiveInsights(Collection<ProactiveOrganizationInsightSummary.BuilderImpl> proactiveInsights) {
            this.proactiveInsights = ProactiveOrganizationInsightsCopier.copyFromBuilder(proactiveInsights);
        }

        @Override
        public final Builder proactiveInsights(Collection<ProactiveOrganizationInsightSummary> proactiveInsights) {
            this.proactiveInsights = ProactiveOrganizationInsightsCopier.copy(proactiveInsights);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder proactiveInsights(ProactiveOrganizationInsightSummary ... proactiveInsights) {
            this.proactiveInsights(Arrays.asList(proactiveInsights));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder proactiveInsights(Consumer<ProactiveOrganizationInsightSummary.Builder> ... proactiveInsights) {
            this.proactiveInsights(Stream.of(proactiveInsights).map(c -> (ProactiveOrganizationInsightSummary)((ProactiveOrganizationInsightSummary.Builder)ProactiveOrganizationInsightSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ReactiveOrganizationInsightSummary.Builder> getReactiveInsights() {
            List<ReactiveOrganizationInsightSummary.Builder> result = ReactiveOrganizationInsightsCopier.copyToBuilder(this.reactiveInsights);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setReactiveInsights(Collection<ReactiveOrganizationInsightSummary.BuilderImpl> reactiveInsights) {
            this.reactiveInsights = ReactiveOrganizationInsightsCopier.copyFromBuilder(reactiveInsights);
        }

        @Override
        public final Builder reactiveInsights(Collection<ReactiveOrganizationInsightSummary> reactiveInsights) {
            this.reactiveInsights = ReactiveOrganizationInsightsCopier.copy(reactiveInsights);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reactiveInsights(ReactiveOrganizationInsightSummary ... reactiveInsights) {
            this.reactiveInsights(Arrays.asList(reactiveInsights));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reactiveInsights(Consumer<ReactiveOrganizationInsightSummary.Builder> ... reactiveInsights) {
            this.reactiveInsights(Stream.of(reactiveInsights).map(c -> (ReactiveOrganizationInsightSummary)((ReactiveOrganizationInsightSummary.Builder)ReactiveOrganizationInsightSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListOrganizationInsightsResponse build() {
            return new ListOrganizationInsightsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DevOpsGuruResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListOrganizationInsightsResponse> {
        public Builder proactiveInsights(Collection<ProactiveOrganizationInsightSummary> var1);

        public Builder proactiveInsights(ProactiveOrganizationInsightSummary ... var1);

        public Builder proactiveInsights(Consumer<ProactiveOrganizationInsightSummary.Builder> ... var1);

        public Builder reactiveInsights(Collection<ReactiveOrganizationInsightSummary> var1);

        public Builder reactiveInsights(ReactiveOrganizationInsightSummary ... var1);

        public Builder reactiveInsights(Consumer<ReactiveOrganizationInsightSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

