/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devopsguru.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum EventDataSource {
    AWS_CLOUD_TRAIL("AWS_CLOUD_TRAIL"),
    AWS_CODE_DEPLOY("AWS_CODE_DEPLOY"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, EventDataSource> VALUE_MAP;
    private final String value;

    private EventDataSource(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static EventDataSource fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<EventDataSource> knownValues() {
        EnumSet<EventDataSource> knownValues = EnumSet.allOf(EventDataSource.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(EventDataSource.class, EventDataSource::toString);
    }
}

