/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.devicefarm.model.DeviceFarmResponse;
import software.amazon.awssdk.services.devicefarm.model.VPCEConfiguration;
import software.amazon.awssdk.services.devicefarm.model.VPCEConfigurationsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListVpceConfigurationsResponse
extends DeviceFarmResponse
implements ToCopyableBuilder<Builder, ListVpceConfigurationsResponse> {
    private static final SdkField<List<VPCEConfiguration>> VPCE_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("vpceConfigurations").getter(ListVpceConfigurationsResponse.getter(ListVpceConfigurationsResponse::vpceConfigurations)).setter(ListVpceConfigurationsResponse.setter(Builder::vpceConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpceConfigurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(VPCEConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListVpceConfigurationsResponse.getter(ListVpceConfigurationsResponse::nextToken)).setter(ListVpceConfigurationsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VPCE_CONFIGURATIONS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListVpceConfigurationsResponse.memberNameToFieldInitializer();
    private final List<VPCEConfiguration> vpceConfigurations;
    private final String nextToken;

    private ListVpceConfigurationsResponse(BuilderImpl builder) {
        super(builder);
        this.vpceConfigurations = builder.vpceConfigurations;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasVpceConfigurations() {
        return this.vpceConfigurations != null && !(this.vpceConfigurations instanceof SdkAutoConstructList);
    }

    public final List<VPCEConfiguration> vpceConfigurations() {
        return this.vpceConfigurations;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVpceConfigurations() ? this.vpceConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListVpceConfigurationsResponse)) {
            return false;
        }
        ListVpceConfigurationsResponse other = (ListVpceConfigurationsResponse)((Object)obj);
        return this.hasVpceConfigurations() == other.hasVpceConfigurations() && Objects.equals(this.vpceConfigurations(), other.vpceConfigurations()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListVpceConfigurationsResponse").add("VpceConfigurations", this.hasVpceConfigurations() ? this.vpceConfigurations() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "vpceConfigurations": {
                return Optional.ofNullable(clazz.cast(this.vpceConfigurations()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("vpceConfigurations", VPCE_CONFIGURATIONS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListVpceConfigurationsResponse, T> g) {
        return obj -> g.apply((ListVpceConfigurationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DeviceFarmResponse.BuilderImpl
    implements Builder {
        private List<VPCEConfiguration> vpceConfigurations = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListVpceConfigurationsResponse model) {
            super(model);
            this.vpceConfigurations(model.vpceConfigurations);
            this.nextToken(model.nextToken);
        }

        public final List<VPCEConfiguration.Builder> getVpceConfigurations() {
            List<VPCEConfiguration.Builder> result = VPCEConfigurationsCopier.copyToBuilder(this.vpceConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVpceConfigurations(Collection<VPCEConfiguration.BuilderImpl> vpceConfigurations) {
            this.vpceConfigurations = VPCEConfigurationsCopier.copyFromBuilder(vpceConfigurations);
        }

        @Override
        public final Builder vpceConfigurations(Collection<VPCEConfiguration> vpceConfigurations) {
            this.vpceConfigurations = VPCEConfigurationsCopier.copy(vpceConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpceConfigurations(VPCEConfiguration ... vpceConfigurations) {
            this.vpceConfigurations(Arrays.asList(vpceConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpceConfigurations(Consumer<VPCEConfiguration.Builder> ... vpceConfigurations) {
            this.vpceConfigurations(Stream.of(vpceConfigurations).map(c -> (VPCEConfiguration)((VPCEConfiguration.Builder)VPCEConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListVpceConfigurationsResponse build() {
            return new ListVpceConfigurationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends DeviceFarmResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListVpceConfigurationsResponse> {
        public Builder vpceConfigurations(Collection<VPCEConfiguration> var1);

        public Builder vpceConfigurations(VPCEConfiguration ... var1);

        public Builder vpceConfigurations(Consumer<VPCEConfiguration.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

