/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.devicefarm.model.BillingMethod;
import software.amazon.awssdk.services.devicefarm.model.Device;
import software.amazon.awssdk.services.devicefarm.model.DeviceMinutes;
import software.amazon.awssdk.services.devicefarm.model.DeviceProxy;
import software.amazon.awssdk.services.devicefarm.model.ExecutionResult;
import software.amazon.awssdk.services.devicefarm.model.ExecutionStatus;
import software.amazon.awssdk.services.devicefarm.model.InteractionMode;
import software.amazon.awssdk.services.devicefarm.model.RemoteAccessEndpoints;
import software.amazon.awssdk.services.devicefarm.model.VpcConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RemoteAccessSession
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RemoteAccessSession> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(RemoteAccessSession.getter(RemoteAccessSession::arn)).setter(RemoteAccessSession.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(RemoteAccessSession.getter(RemoteAccessSession::name)).setter(RemoteAccessSession.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<Instant> CREATED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("created").getter(RemoteAccessSession.getter(RemoteAccessSession::created)).setter(RemoteAccessSession.setter(Builder::created)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("created").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(RemoteAccessSession.getter(RemoteAccessSession::statusAsString)).setter(RemoteAccessSession.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> RESULT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("result").getter(RemoteAccessSession.getter(RemoteAccessSession::resultAsString)).setter(RemoteAccessSession.setter(Builder::result)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("result").build()}).build();
    private static final SdkField<String> MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("message").getter(RemoteAccessSession.getter(RemoteAccessSession::message)).setter(RemoteAccessSession.setter(Builder::message)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("message").build()}).build();
    private static final SdkField<Instant> STARTED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("started").getter(RemoteAccessSession.getter(RemoteAccessSession::started)).setter(RemoteAccessSession.setter(Builder::started)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("started").build()}).build();
    private static final SdkField<Instant> STOPPED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("stopped").getter(RemoteAccessSession.getter(RemoteAccessSession::stopped)).setter(RemoteAccessSession.setter(Builder::stopped)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stopped").build()}).build();
    private static final SdkField<Device> DEVICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("device").getter(RemoteAccessSession.getter(RemoteAccessSession::device)).setter(RemoteAccessSession.setter(Builder::device)).constructor(Device::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("device").build()}).build();
    private static final SdkField<String> INSTANCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("instanceArn").getter(RemoteAccessSession.getter(RemoteAccessSession::instanceArn)).setter(RemoteAccessSession.setter(Builder::instanceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceArn").build()}).build();
    private static final SdkField<String> BILLING_METHOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("billingMethod").getter(RemoteAccessSession.getter(RemoteAccessSession::billingMethodAsString)).setter(RemoteAccessSession.setter(Builder::billingMethod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("billingMethod").build()}).build();
    private static final SdkField<DeviceMinutes> DEVICE_MINUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("deviceMinutes").getter(RemoteAccessSession.getter(RemoteAccessSession::deviceMinutes)).setter(RemoteAccessSession.setter(Builder::deviceMinutes)).constructor(DeviceMinutes::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deviceMinutes").build()}).build();
    private static final SdkField<String> ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("endpoint").getter(RemoteAccessSession.getter(RemoteAccessSession::endpoint)).setter(RemoteAccessSession.setter(Builder::endpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endpoint").build()}).build();
    private static final SdkField<String> DEVICE_UDID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("deviceUdid").getter(RemoteAccessSession.getter(RemoteAccessSession::deviceUdid)).setter(RemoteAccessSession.setter(Builder::deviceUdid)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deviceUdid").build()}).build();
    private static final SdkField<String> INTERACTION_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("interactionMode").getter(RemoteAccessSession.getter(RemoteAccessSession::interactionModeAsString)).setter(RemoteAccessSession.setter(Builder::interactionMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("interactionMode").build()}).build();
    private static final SdkField<Boolean> SKIP_APP_RESIGN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("skipAppResign").getter(RemoteAccessSession.getter(RemoteAccessSession::skipAppResign)).setter(RemoteAccessSession.setter(Builder::skipAppResign)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("skipAppResign").build()}).build();
    private static final SdkField<VpcConfig> VPC_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("vpcConfig").getter(RemoteAccessSession.getter(RemoteAccessSession::vpcConfig)).setter(RemoteAccessSession.setter(Builder::vpcConfig)).constructor(VpcConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcConfig").build()}).build();
    private static final SdkField<DeviceProxy> DEVICE_PROXY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("deviceProxy").getter(RemoteAccessSession.getter(RemoteAccessSession::deviceProxy)).setter(RemoteAccessSession.setter(Builder::deviceProxy)).constructor(DeviceProxy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deviceProxy").build()}).build();
    private static final SdkField<String> APP_UPLOAD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("appUpload").getter(RemoteAccessSession.getter(RemoteAccessSession::appUpload)).setter(RemoteAccessSession.setter(Builder::appUpload)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appUpload").build()}).build();
    private static final SdkField<RemoteAccessEndpoints> ENDPOINTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("endpoints").getter(RemoteAccessSession.getter(RemoteAccessSession::endpoints)).setter(RemoteAccessSession.setter(Builder::endpoints)).constructor(RemoteAccessEndpoints::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endpoints").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, NAME_FIELD, CREATED_FIELD, STATUS_FIELD, RESULT_FIELD, MESSAGE_FIELD, STARTED_FIELD, STOPPED_FIELD, DEVICE_FIELD, INSTANCE_ARN_FIELD, BILLING_METHOD_FIELD, DEVICE_MINUTES_FIELD, ENDPOINT_FIELD, DEVICE_UDID_FIELD, INTERACTION_MODE_FIELD, SKIP_APP_RESIGN_FIELD, VPC_CONFIG_FIELD, DEVICE_PROXY_FIELD, APP_UPLOAD_FIELD, ENDPOINTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RemoteAccessSession.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final String name;
    private final Instant created;
    private final String status;
    private final String result;
    private final String message;
    private final Instant started;
    private final Instant stopped;
    private final Device device;
    private final String instanceArn;
    private final String billingMethod;
    private final DeviceMinutes deviceMinutes;
    private final String endpoint;
    private final String deviceUdid;
    private final String interactionMode;
    private final Boolean skipAppResign;
    private final VpcConfig vpcConfig;
    private final DeviceProxy deviceProxy;
    private final String appUpload;
    private final RemoteAccessEndpoints endpoints;

    private RemoteAccessSession(BuilderImpl builder) {
        this.arn = builder.arn;
        this.name = builder.name;
        this.created = builder.created;
        this.status = builder.status;
        this.result = builder.result;
        this.message = builder.message;
        this.started = builder.started;
        this.stopped = builder.stopped;
        this.device = builder.device;
        this.instanceArn = builder.instanceArn;
        this.billingMethod = builder.billingMethod;
        this.deviceMinutes = builder.deviceMinutes;
        this.endpoint = builder.endpoint;
        this.deviceUdid = builder.deviceUdid;
        this.interactionMode = builder.interactionMode;
        this.skipAppResign = builder.skipAppResign;
        this.vpcConfig = builder.vpcConfig;
        this.deviceProxy = builder.deviceProxy;
        this.appUpload = builder.appUpload;
        this.endpoints = builder.endpoints;
    }

    public final String arn() {
        return this.arn;
    }

    public final String name() {
        return this.name;
    }

    public final Instant created() {
        return this.created;
    }

    public final ExecutionStatus status() {
        return ExecutionStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final ExecutionResult result() {
        return ExecutionResult.fromValue(this.result);
    }

    public final String resultAsString() {
        return this.result;
    }

    public final String message() {
        return this.message;
    }

    public final Instant started() {
        return this.started;
    }

    public final Instant stopped() {
        return this.stopped;
    }

    public final Device device() {
        return this.device;
    }

    public final String instanceArn() {
        return this.instanceArn;
    }

    public final BillingMethod billingMethod() {
        return BillingMethod.fromValue(this.billingMethod);
    }

    public final String billingMethodAsString() {
        return this.billingMethod;
    }

    public final DeviceMinutes deviceMinutes() {
        return this.deviceMinutes;
    }

    @Deprecated
    public final String endpoint() {
        return this.endpoint;
    }

    public final String deviceUdid() {
        return this.deviceUdid;
    }

    @Deprecated
    public final InteractionMode interactionMode() {
        return InteractionMode.fromValue(this.interactionMode);
    }

    @Deprecated
    public final String interactionModeAsString() {
        return this.interactionMode;
    }

    public final Boolean skipAppResign() {
        return this.skipAppResign;
    }

    public final VpcConfig vpcConfig() {
        return this.vpcConfig;
    }

    public final DeviceProxy deviceProxy() {
        return this.deviceProxy;
    }

    public final String appUpload() {
        return this.appUpload;
    }

    public final RemoteAccessEndpoints endpoints() {
        return this.endpoints;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.created());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.resultAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.message());
        hashCode = 31 * hashCode + Objects.hashCode(this.started());
        hashCode = 31 * hashCode + Objects.hashCode(this.stopped());
        hashCode = 31 * hashCode + Objects.hashCode(this.device());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.billingMethodAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceUdid());
        hashCode = 31 * hashCode + Objects.hashCode(this.interactionModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.skipAppResign());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceProxy());
        hashCode = 31 * hashCode + Objects.hashCode(this.appUpload());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpoints());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RemoteAccessSession)) {
            return false;
        }
        RemoteAccessSession other = (RemoteAccessSession)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.created(), other.created()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.resultAsString(), other.resultAsString()) && Objects.equals(this.message(), other.message()) && Objects.equals(this.started(), other.started()) && Objects.equals(this.stopped(), other.stopped()) && Objects.equals(this.device(), other.device()) && Objects.equals(this.instanceArn(), other.instanceArn()) && Objects.equals(this.billingMethodAsString(), other.billingMethodAsString()) && Objects.equals(this.deviceMinutes(), other.deviceMinutes()) && Objects.equals(this.endpoint(), other.endpoint()) && Objects.equals(this.deviceUdid(), other.deviceUdid()) && Objects.equals(this.interactionModeAsString(), other.interactionModeAsString()) && Objects.equals(this.skipAppResign(), other.skipAppResign()) && Objects.equals(this.vpcConfig(), other.vpcConfig()) && Objects.equals(this.deviceProxy(), other.deviceProxy()) && Objects.equals(this.appUpload(), other.appUpload()) && Objects.equals(this.endpoints(), other.endpoints());
    }

    public final String toString() {
        return ToString.builder((String)"RemoteAccessSession").add("Arn", (Object)this.arn()).add("Name", (Object)this.name()).add("Created", (Object)this.created()).add("Status", (Object)this.statusAsString()).add("Result", (Object)this.resultAsString()).add("Message", (Object)this.message()).add("Started", (Object)this.started()).add("Stopped", (Object)this.stopped()).add("Device", (Object)this.device()).add("InstanceArn", (Object)this.instanceArn()).add("BillingMethod", (Object)this.billingMethodAsString()).add("DeviceMinutes", (Object)this.deviceMinutes()).add("Endpoint", (Object)this.endpoint()).add("DeviceUdid", (Object)this.deviceUdid()).add("InteractionMode", (Object)this.interactionModeAsString()).add("SkipAppResign", (Object)this.skipAppResign()).add("VpcConfig", (Object)this.vpcConfig()).add("DeviceProxy", (Object)this.deviceProxy()).add("AppUpload", (Object)this.appUpload()).add("Endpoints", (Object)this.endpoints()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "created": {
                return Optional.ofNullable(clazz.cast(this.created()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "result": {
                return Optional.ofNullable(clazz.cast(this.resultAsString()));
            }
            case "message": {
                return Optional.ofNullable(clazz.cast(this.message()));
            }
            case "started": {
                return Optional.ofNullable(clazz.cast(this.started()));
            }
            case "stopped": {
                return Optional.ofNullable(clazz.cast(this.stopped()));
            }
            case "device": {
                return Optional.ofNullable(clazz.cast(this.device()));
            }
            case "instanceArn": {
                return Optional.ofNullable(clazz.cast(this.instanceArn()));
            }
            case "billingMethod": {
                return Optional.ofNullable(clazz.cast(this.billingMethodAsString()));
            }
            case "deviceMinutes": {
                return Optional.ofNullable(clazz.cast(this.deviceMinutes()));
            }
            case "endpoint": {
                return Optional.ofNullable(clazz.cast(this.endpoint()));
            }
            case "deviceUdid": {
                return Optional.ofNullable(clazz.cast(this.deviceUdid()));
            }
            case "interactionMode": {
                return Optional.ofNullable(clazz.cast(this.interactionModeAsString()));
            }
            case "skipAppResign": {
                return Optional.ofNullable(clazz.cast(this.skipAppResign()));
            }
            case "vpcConfig": {
                return Optional.ofNullable(clazz.cast(this.vpcConfig()));
            }
            case "deviceProxy": {
                return Optional.ofNullable(clazz.cast(this.deviceProxy()));
            }
            case "appUpload": {
                return Optional.ofNullable(clazz.cast(this.appUpload()));
            }
            case "endpoints": {
                return Optional.ofNullable(clazz.cast(this.endpoints()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("arn", ARN_FIELD);
        map.put("name", NAME_FIELD);
        map.put("created", CREATED_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("result", RESULT_FIELD);
        map.put("message", MESSAGE_FIELD);
        map.put("started", STARTED_FIELD);
        map.put("stopped", STOPPED_FIELD);
        map.put("device", DEVICE_FIELD);
        map.put("instanceArn", INSTANCE_ARN_FIELD);
        map.put("billingMethod", BILLING_METHOD_FIELD);
        map.put("deviceMinutes", DEVICE_MINUTES_FIELD);
        map.put("endpoint", ENDPOINT_FIELD);
        map.put("deviceUdid", DEVICE_UDID_FIELD);
        map.put("interactionMode", INTERACTION_MODE_FIELD);
        map.put("skipAppResign", SKIP_APP_RESIGN_FIELD);
        map.put("vpcConfig", VPC_CONFIG_FIELD);
        map.put("deviceProxy", DEVICE_PROXY_FIELD);
        map.put("appUpload", APP_UPLOAD_FIELD);
        map.put("endpoints", ENDPOINTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RemoteAccessSession, T> g) {
        return obj -> g.apply((RemoteAccessSession)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String name;
        private Instant created;
        private String status;
        private String result;
        private String message;
        private Instant started;
        private Instant stopped;
        private Device device;
        private String instanceArn;
        private String billingMethod;
        private DeviceMinutes deviceMinutes;
        private String endpoint;
        private String deviceUdid;
        private String interactionMode;
        private Boolean skipAppResign;
        private VpcConfig vpcConfig;
        private DeviceProxy deviceProxy;
        private String appUpload;
        private RemoteAccessEndpoints endpoints;

        private BuilderImpl() {
        }

        private BuilderImpl(RemoteAccessSession model) {
            this.arn(model.arn);
            this.name(model.name);
            this.created(model.created);
            this.status(model.status);
            this.result(model.result);
            this.message(model.message);
            this.started(model.started);
            this.stopped(model.stopped);
            this.device(model.device);
            this.instanceArn(model.instanceArn);
            this.billingMethod(model.billingMethod);
            this.deviceMinutes(model.deviceMinutes);
            this.endpoint(model.endpoint);
            this.deviceUdid(model.deviceUdid);
            this.interactionMode(model.interactionMode);
            this.skipAppResign(model.skipAppResign);
            this.vpcConfig(model.vpcConfig);
            this.deviceProxy(model.deviceProxy);
            this.appUpload(model.appUpload);
            this.endpoints(model.endpoints);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Instant getCreated() {
            return this.created;
        }

        public final void setCreated(Instant created) {
            this.created = created;
        }

        @Override
        public final Builder created(Instant created) {
            this.created = created;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ExecutionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getResult() {
            return this.result;
        }

        public final void setResult(String result) {
            this.result = result;
        }

        @Override
        public final Builder result(String result) {
            this.result = result;
            return this;
        }

        @Override
        public final Builder result(ExecutionResult result) {
            this.result(result == null ? null : result.toString());
            return this;
        }

        public final String getMessage() {
            return this.message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final Instant getStarted() {
            return this.started;
        }

        public final void setStarted(Instant started) {
            this.started = started;
        }

        @Override
        public final Builder started(Instant started) {
            this.started = started;
            return this;
        }

        public final Instant getStopped() {
            return this.stopped;
        }

        public final void setStopped(Instant stopped) {
            this.stopped = stopped;
        }

        @Override
        public final Builder stopped(Instant stopped) {
            this.stopped = stopped;
            return this;
        }

        public final Device.Builder getDevice() {
            return this.device != null ? this.device.toBuilder() : null;
        }

        public final void setDevice(Device.BuilderImpl device) {
            this.device = device != null ? device.build() : null;
        }

        @Override
        public final Builder device(Device device) {
            this.device = device;
            return this;
        }

        public final String getInstanceArn() {
            return this.instanceArn;
        }

        public final void setInstanceArn(String instanceArn) {
            this.instanceArn = instanceArn;
        }

        @Override
        public final Builder instanceArn(String instanceArn) {
            this.instanceArn = instanceArn;
            return this;
        }

        public final String getBillingMethod() {
            return this.billingMethod;
        }

        public final void setBillingMethod(String billingMethod) {
            this.billingMethod = billingMethod;
        }

        @Override
        public final Builder billingMethod(String billingMethod) {
            this.billingMethod = billingMethod;
            return this;
        }

        @Override
        public final Builder billingMethod(BillingMethod billingMethod) {
            this.billingMethod(billingMethod == null ? null : billingMethod.toString());
            return this;
        }

        public final DeviceMinutes.Builder getDeviceMinutes() {
            return this.deviceMinutes != null ? this.deviceMinutes.toBuilder() : null;
        }

        public final void setDeviceMinutes(DeviceMinutes.BuilderImpl deviceMinutes) {
            this.deviceMinutes = deviceMinutes != null ? deviceMinutes.build() : null;
        }

        @Override
        public final Builder deviceMinutes(DeviceMinutes deviceMinutes) {
            this.deviceMinutes = deviceMinutes;
            return this;
        }

        @Deprecated
        public final String getEndpoint() {
            return this.endpoint;
        }

        @Deprecated
        public final void setEndpoint(String endpoint) {
            this.endpoint = endpoint;
        }

        @Override
        @Deprecated
        public final Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public final String getDeviceUdid() {
            return this.deviceUdid;
        }

        public final void setDeviceUdid(String deviceUdid) {
            this.deviceUdid = deviceUdid;
        }

        @Override
        public final Builder deviceUdid(String deviceUdid) {
            this.deviceUdid = deviceUdid;
            return this;
        }

        @Deprecated
        public final String getInteractionMode() {
            return this.interactionMode;
        }

        @Deprecated
        public final void setInteractionMode(String interactionMode) {
            this.interactionMode = interactionMode;
        }

        @Override
        @Deprecated
        public final Builder interactionMode(String interactionMode) {
            this.interactionMode = interactionMode;
            return this;
        }

        @Override
        @Deprecated
        public final Builder interactionMode(InteractionMode interactionMode) {
            this.interactionMode(interactionMode == null ? null : interactionMode.toString());
            return this;
        }

        public final Boolean getSkipAppResign() {
            return this.skipAppResign;
        }

        public final void setSkipAppResign(Boolean skipAppResign) {
            this.skipAppResign = skipAppResign;
        }

        @Override
        public final Builder skipAppResign(Boolean skipAppResign) {
            this.skipAppResign = skipAppResign;
            return this;
        }

        public final VpcConfig.Builder getVpcConfig() {
            return this.vpcConfig != null ? this.vpcConfig.toBuilder() : null;
        }

        public final void setVpcConfig(VpcConfig.BuilderImpl vpcConfig) {
            this.vpcConfig = vpcConfig != null ? vpcConfig.build() : null;
        }

        @Override
        public final Builder vpcConfig(VpcConfig vpcConfig) {
            this.vpcConfig = vpcConfig;
            return this;
        }

        public final DeviceProxy.Builder getDeviceProxy() {
            return this.deviceProxy != null ? this.deviceProxy.toBuilder() : null;
        }

        public final void setDeviceProxy(DeviceProxy.BuilderImpl deviceProxy) {
            this.deviceProxy = deviceProxy != null ? deviceProxy.build() : null;
        }

        @Override
        public final Builder deviceProxy(DeviceProxy deviceProxy) {
            this.deviceProxy = deviceProxy;
            return this;
        }

        public final String getAppUpload() {
            return this.appUpload;
        }

        public final void setAppUpload(String appUpload) {
            this.appUpload = appUpload;
        }

        @Override
        public final Builder appUpload(String appUpload) {
            this.appUpload = appUpload;
            return this;
        }

        public final RemoteAccessEndpoints.Builder getEndpoints() {
            return this.endpoints != null ? this.endpoints.toBuilder() : null;
        }

        public final void setEndpoints(RemoteAccessEndpoints.BuilderImpl endpoints) {
            this.endpoints = endpoints != null ? endpoints.build() : null;
        }

        @Override
        public final Builder endpoints(RemoteAccessEndpoints endpoints) {
            this.endpoints = endpoints;
            return this;
        }

        public RemoteAccessSession build() {
            return new RemoteAccessSession(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RemoteAccessSession> {
        public Builder arn(String var1);

        public Builder name(String var1);

        public Builder created(Instant var1);

        public Builder status(String var1);

        public Builder status(ExecutionStatus var1);

        public Builder result(String var1);

        public Builder result(ExecutionResult var1);

        public Builder message(String var1);

        public Builder started(Instant var1);

        public Builder stopped(Instant var1);

        public Builder device(Device var1);

        default public Builder device(Consumer<Device.Builder> device) {
            return this.device((Device)((Device.Builder)Device.builder().applyMutation(device)).build());
        }

        public Builder instanceArn(String var1);

        public Builder billingMethod(String var1);

        public Builder billingMethod(BillingMethod var1);

        public Builder deviceMinutes(DeviceMinutes var1);

        default public Builder deviceMinutes(Consumer<DeviceMinutes.Builder> deviceMinutes) {
            return this.deviceMinutes((DeviceMinutes)((DeviceMinutes.Builder)DeviceMinutes.builder().applyMutation(deviceMinutes)).build());
        }

        @Deprecated
        public Builder endpoint(String var1);

        public Builder deviceUdid(String var1);

        @Deprecated
        public Builder interactionMode(String var1);

        @Deprecated
        public Builder interactionMode(InteractionMode var1);

        public Builder skipAppResign(Boolean var1);

        public Builder vpcConfig(VpcConfig var1);

        default public Builder vpcConfig(Consumer<VpcConfig.Builder> vpcConfig) {
            return this.vpcConfig((VpcConfig)((VpcConfig.Builder)VpcConfig.builder().applyMutation(vpcConfig)).build());
        }

        public Builder deviceProxy(DeviceProxy var1);

        default public Builder deviceProxy(Consumer<DeviceProxy.Builder> deviceProxy) {
            return this.deviceProxy((DeviceProxy)((DeviceProxy.Builder)DeviceProxy.builder().applyMutation(deviceProxy)).build());
        }

        public Builder appUpload(String var1);

        public Builder endpoints(RemoteAccessEndpoints var1);

        default public Builder endpoints(Consumer<RemoteAccessEndpoints.Builder> endpoints) {
            return this.endpoints((RemoteAccessEndpoints)((RemoteAccessEndpoints.Builder)RemoteAccessEndpoints.builder().applyMutation(endpoints)).build());
        }
    }
}

