/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.deadline.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.document.Document;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.deadline.DeadlineClient;
import software.amazon.awssdk.services.deadline.internal.UserAgentUtils;
import software.amazon.awssdk.services.deadline.model.ListJobParameterDefinitionsRequest;
import software.amazon.awssdk.services.deadline.model.ListJobParameterDefinitionsResponse;

public class ListJobParameterDefinitionsIterable
implements SdkIterable<ListJobParameterDefinitionsResponse> {
    private final DeadlineClient client;
    private final ListJobParameterDefinitionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListJobParameterDefinitionsIterable(DeadlineClient client, ListJobParameterDefinitionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListJobParameterDefinitionsResponseFetcher();
    }

    public Iterator<ListJobParameterDefinitionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Document> jobParameterDefinitions() {
        Function<ListJobParameterDefinitionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.jobParameterDefinitions() != null) {
                return response.jobParameterDefinitions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListJobParameterDefinitionsResponseFetcher
    implements SyncPageFetcher<ListJobParameterDefinitionsResponse> {
        private ListJobParameterDefinitionsResponseFetcher() {
        }

        public boolean hasNextPage(ListJobParameterDefinitionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListJobParameterDefinitionsResponse nextPage(ListJobParameterDefinitionsResponse previousPage) {
            if (previousPage == null) {
                return ListJobParameterDefinitionsIterable.this.client.listJobParameterDefinitions(ListJobParameterDefinitionsIterable.this.firstRequest);
            }
            return ListJobParameterDefinitionsIterable.this.client.listJobParameterDefinitions((ListJobParameterDefinitionsRequest)((Object)ListJobParameterDefinitionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

