/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.deadline.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.deadline.DeadlineClient;
import software.amazon.awssdk.services.deadline.internal.UserAgentUtils;
import software.amazon.awssdk.services.deadline.model.FleetMember;
import software.amazon.awssdk.services.deadline.model.ListFleetMembersRequest;
import software.amazon.awssdk.services.deadline.model.ListFleetMembersResponse;

public class ListFleetMembersIterable
implements SdkIterable<ListFleetMembersResponse> {
    private final DeadlineClient client;
    private final ListFleetMembersRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListFleetMembersIterable(DeadlineClient client, ListFleetMembersRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListFleetMembersResponseFetcher();
    }

    public Iterator<ListFleetMembersResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<FleetMember> members() {
        Function<ListFleetMembersResponse, Iterator> getIterator = response -> {
            if (response != null && response.members() != null) {
                return response.members().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListFleetMembersResponseFetcher
    implements SyncPageFetcher<ListFleetMembersResponse> {
        private ListFleetMembersResponseFetcher() {
        }

        public boolean hasNextPage(ListFleetMembersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListFleetMembersResponse nextPage(ListFleetMembersResponse previousPage) {
            if (previousPage == null) {
                return ListFleetMembersIterable.this.client.listFleetMembers(ListFleetMembersIterable.this.firstRequest);
            }
            return ListFleetMembersIterable.this.client.listFleetMembers((ListFleetMembersRequest)((Object)ListFleetMembersIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

