/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.deadline.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.deadline.DeadlineAsyncClient;
import software.amazon.awssdk.services.deadline.internal.UserAgentUtils;
import software.amazon.awssdk.services.deadline.model.GetSessionsStatisticsAggregationRequest;
import software.amazon.awssdk.services.deadline.model.GetSessionsStatisticsAggregationResponse;
import software.amazon.awssdk.services.deadline.model.Statistics;

public class GetSessionsStatisticsAggregationPublisher
implements SdkPublisher<GetSessionsStatisticsAggregationResponse> {
    private final DeadlineAsyncClient client;
    private final GetSessionsStatisticsAggregationRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetSessionsStatisticsAggregationPublisher(DeadlineAsyncClient client, GetSessionsStatisticsAggregationRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetSessionsStatisticsAggregationPublisher(DeadlineAsyncClient client, GetSessionsStatisticsAggregationRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetSessionsStatisticsAggregationResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetSessionsStatisticsAggregationResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Statistics> statistics() {
        Function<GetSessionsStatisticsAggregationResponse, Iterator> getIterator = response -> {
            if (response != null && response.statistics() != null) {
                return response.statistics().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new GetSessionsStatisticsAggregationResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class GetSessionsStatisticsAggregationResponseFetcher
    implements AsyncPageFetcher<GetSessionsStatisticsAggregationResponse> {
        private GetSessionsStatisticsAggregationResponseFetcher() {
        }

        public boolean hasNextPage(GetSessionsStatisticsAggregationResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetSessionsStatisticsAggregationResponse> nextPage(GetSessionsStatisticsAggregationResponse previousPage) {
            if (previousPage == null) {
                return GetSessionsStatisticsAggregationPublisher.this.client.getSessionsStatisticsAggregation(GetSessionsStatisticsAggregationPublisher.this.firstRequest);
            }
            return GetSessionsStatisticsAggregationPublisher.this.client.getSessionsStatisticsAggregation((GetSessionsStatisticsAggregationRequest)((Object)GetSessionsStatisticsAggregationPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

