/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.deadline.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.deadline.model.DeadlineRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateLimitRequest
extends DeadlineRequest
implements ToCopyableBuilder<Builder, UpdateLimitRequest> {
    private static final SdkField<String> FARM_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("farmId").getter(UpdateLimitRequest.getter(UpdateLimitRequest::farmId)).setter(UpdateLimitRequest.setter(Builder::farmId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("farmId").build()}).build();
    private static final SdkField<String> LIMIT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("limitId").getter(UpdateLimitRequest.getter(UpdateLimitRequest::limitId)).setter(UpdateLimitRequest.setter(Builder::limitId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("limitId").build()}).build();
    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("displayName").getter(UpdateLimitRequest.getter(UpdateLimitRequest::displayName)).setter(UpdateLimitRequest.setter(Builder::displayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(UpdateLimitRequest.getter(UpdateLimitRequest::description)).setter(UpdateLimitRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<Integer> MAX_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxCount").getter(UpdateLimitRequest.getter(UpdateLimitRequest::maxCount)).setter(UpdateLimitRequest.setter(Builder::maxCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxCount").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FARM_ID_FIELD, LIMIT_ID_FIELD, DISPLAY_NAME_FIELD, DESCRIPTION_FIELD, MAX_COUNT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateLimitRequest.memberNameToFieldInitializer();
    private final String farmId;
    private final String limitId;
    private final String displayName;
    private final String description;
    private final Integer maxCount;

    private UpdateLimitRequest(BuilderImpl builder) {
        super(builder);
        this.farmId = builder.farmId;
        this.limitId = builder.limitId;
        this.displayName = builder.displayName;
        this.description = builder.description;
        this.maxCount = builder.maxCount;
    }

    public final String farmId() {
        return this.farmId;
    }

    public final String limitId() {
        return this.limitId;
    }

    public final String displayName() {
        return this.displayName;
    }

    public final String description() {
        return this.description;
    }

    public final Integer maxCount() {
        return this.maxCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.farmId());
        hashCode = 31 * hashCode + Objects.hashCode(this.limitId());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxCount());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateLimitRequest)) {
            return false;
        }
        UpdateLimitRequest other = (UpdateLimitRequest)((Object)obj);
        return Objects.equals(this.farmId(), other.farmId()) && Objects.equals(this.limitId(), other.limitId()) && Objects.equals(this.displayName(), other.displayName()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.maxCount(), other.maxCount());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateLimitRequest").add("FarmId", (Object)this.farmId()).add("LimitId", (Object)this.limitId()).add("DisplayName", (Object)this.displayName()).add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("MaxCount", (Object)this.maxCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "farmId": {
                return Optional.ofNullable(clazz.cast(this.farmId()));
            }
            case "limitId": {
                return Optional.ofNullable(clazz.cast(this.limitId()));
            }
            case "displayName": {
                return Optional.ofNullable(clazz.cast(this.displayName()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "maxCount": {
                return Optional.ofNullable(clazz.cast(this.maxCount()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("farmId", FARM_ID_FIELD);
        map.put("limitId", LIMIT_ID_FIELD);
        map.put("displayName", DISPLAY_NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("maxCount", MAX_COUNT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateLimitRequest, T> g) {
        return obj -> g.apply((UpdateLimitRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DeadlineRequest.BuilderImpl
    implements Builder {
        private String farmId;
        private String limitId;
        private String displayName;
        private String description;
        private Integer maxCount;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateLimitRequest model) {
            super(model);
            this.farmId(model.farmId);
            this.limitId(model.limitId);
            this.displayName(model.displayName);
            this.description(model.description);
            this.maxCount(model.maxCount);
        }

        public final String getFarmId() {
            return this.farmId;
        }

        public final void setFarmId(String farmId) {
            this.farmId = farmId;
        }

        @Override
        public final Builder farmId(String farmId) {
            this.farmId = farmId;
            return this;
        }

        public final String getLimitId() {
            return this.limitId;
        }

        public final void setLimitId(String limitId) {
            this.limitId = limitId;
        }

        @Override
        public final Builder limitId(String limitId) {
            this.limitId = limitId;
            return this;
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Integer getMaxCount() {
            return this.maxCount;
        }

        public final void setMaxCount(Integer maxCount) {
            this.maxCount = maxCount;
        }

        @Override
        public final Builder maxCount(Integer maxCount) {
            this.maxCount = maxCount;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateLimitRequest build() {
            return new UpdateLimitRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends DeadlineRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateLimitRequest> {
        public Builder farmId(String var1);

        public Builder limitId(String var1);

        public Builder displayName(String var1);

        public Builder description(String var1);

        public Builder maxCount(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

