/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.deadline.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum SessionActionStatus {
    ASSIGNED("ASSIGNED"),
    RUNNING("RUNNING"),
    CANCELING("CANCELING"),
    SUCCEEDED("SUCCEEDED"),
    FAILED("FAILED"),
    INTERRUPTED("INTERRUPTED"),
    CANCELED("CANCELED"),
    NEVER_ATTEMPTED("NEVER_ATTEMPTED"),
    SCHEDULED("SCHEDULED"),
    RECLAIMING("RECLAIMING"),
    RECLAIMED("RECLAIMED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, SessionActionStatus> VALUE_MAP;
    private final String value;

    private SessionActionStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static SessionActionStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<SessionActionStatus> knownValues() {
        EnumSet<SessionActionStatus> knownValues = EnumSet.allOf(SessionActionStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(SessionActionStatus.class, SessionActionStatus::toString);
    }
}

