/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.deadline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.deadline.model.BudgetActionType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResponseBudgetAction
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ResponseBudgetAction> {
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(ResponseBudgetAction.getter(ResponseBudgetAction::typeAsString)).setter(ResponseBudgetAction.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<Float> THRESHOLD_PERCENTAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).memberName("thresholdPercentage").getter(ResponseBudgetAction.getter(ResponseBudgetAction::thresholdPercentage)).setter(ResponseBudgetAction.setter(Builder::thresholdPercentage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thresholdPercentage").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(ResponseBudgetAction.getter(ResponseBudgetAction::description)).setter(ResponseBudgetAction.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, THRESHOLD_PERCENTAGE_FIELD, DESCRIPTION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ResponseBudgetAction.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String type;
    private final Float thresholdPercentage;
    private final String description;

    private ResponseBudgetAction(BuilderImpl builder) {
        this.type = builder.type;
        this.thresholdPercentage = builder.thresholdPercentage;
        this.description = builder.description;
    }

    public final BudgetActionType type() {
        return BudgetActionType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final Float thresholdPercentage() {
        return this.thresholdPercentage;
    }

    public final String description() {
        return this.description;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.thresholdPercentage());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResponseBudgetAction)) {
            return false;
        }
        ResponseBudgetAction other = (ResponseBudgetAction)obj;
        return Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.thresholdPercentage(), other.thresholdPercentage()) && Objects.equals(this.description(), other.description());
    }

    public final String toString() {
        return ToString.builder((String)"ResponseBudgetAction").add("Type", (Object)this.typeAsString()).add("ThresholdPercentage", (Object)this.thresholdPercentage()).add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "thresholdPercentage": {
                return Optional.ofNullable(clazz.cast(this.thresholdPercentage()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("type", TYPE_FIELD);
        map.put("thresholdPercentage", THRESHOLD_PERCENTAGE_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ResponseBudgetAction, T> g) {
        return obj -> g.apply((ResponseBudgetAction)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String type;
        private Float thresholdPercentage;
        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(ResponseBudgetAction model) {
            this.type(model.type);
            this.thresholdPercentage(model.thresholdPercentage);
            this.description(model.description);
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(BudgetActionType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final Float getThresholdPercentage() {
            return this.thresholdPercentage;
        }

        public final void setThresholdPercentage(Float thresholdPercentage) {
            this.thresholdPercentage = thresholdPercentage;
        }

        @Override
        public final Builder thresholdPercentage(Float thresholdPercentage) {
            this.thresholdPercentage = thresholdPercentage;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public ResponseBudgetAction build() {
            return new ResponseBudgetAction(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ResponseBudgetAction> {
        public Builder type(String var1);

        public Builder type(BudgetActionType var1);

        public Builder thresholdPercentage(Float var1);

        public Builder description(String var1);
    }
}

