/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.deadline.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.deadline.model.DeadlineResponse;
import software.amazon.awssdk.services.deadline.model.StepConsumer;
import software.amazon.awssdk.services.deadline.model.StepConsumersCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListStepConsumersResponse
extends DeadlineResponse
implements ToCopyableBuilder<Builder, ListStepConsumersResponse> {
    private static final SdkField<List<StepConsumer>> CONSUMERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("consumers").getter(ListStepConsumersResponse.getter(ListStepConsumersResponse::consumers)).setter(ListStepConsumersResponse.setter(Builder::consumers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("consumers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(StepConsumer::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListStepConsumersResponse.getter(ListStepConsumersResponse::nextToken)).setter(ListStepConsumersResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONSUMERS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListStepConsumersResponse.memberNameToFieldInitializer();
    private final List<StepConsumer> consumers;
    private final String nextToken;

    private ListStepConsumersResponse(BuilderImpl builder) {
        super(builder);
        this.consumers = builder.consumers;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasConsumers() {
        return this.consumers != null && !(this.consumers instanceof SdkAutoConstructList);
    }

    public final List<StepConsumer> consumers() {
        return this.consumers;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasConsumers() ? this.consumers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListStepConsumersResponse)) {
            return false;
        }
        ListStepConsumersResponse other = (ListStepConsumersResponse)((Object)obj);
        return this.hasConsumers() == other.hasConsumers() && Objects.equals(this.consumers(), other.consumers()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListStepConsumersResponse").add("Consumers", this.hasConsumers() ? this.consumers() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "consumers": {
                return Optional.ofNullable(clazz.cast(this.consumers()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("consumers", CONSUMERS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListStepConsumersResponse, T> g) {
        return obj -> g.apply((ListStepConsumersResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DeadlineResponse.BuilderImpl
    implements Builder {
        private List<StepConsumer> consumers = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListStepConsumersResponse model) {
            super(model);
            this.consumers(model.consumers);
            this.nextToken(model.nextToken);
        }

        public final List<StepConsumer.Builder> getConsumers() {
            List<StepConsumer.Builder> result = StepConsumersCopier.copyToBuilder(this.consumers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setConsumers(Collection<StepConsumer.BuilderImpl> consumers) {
            this.consumers = StepConsumersCopier.copyFromBuilder(consumers);
        }

        @Override
        public final Builder consumers(Collection<StepConsumer> consumers) {
            this.consumers = StepConsumersCopier.copy(consumers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder consumers(StepConsumer ... consumers) {
            this.consumers(Arrays.asList(consumers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder consumers(Consumer<StepConsumer.Builder> ... consumers) {
            this.consumers(Stream.of(consumers).map(c -> (StepConsumer)((StepConsumer.Builder)StepConsumer.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListStepConsumersResponse build() {
            return new ListStepConsumersResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends DeadlineResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListStepConsumersResponse> {
        public Builder consumers(Collection<StepConsumer> var1);

        public Builder consumers(StepConsumer ... var1);

        public Builder consumers(Consumer<StepConsumer.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

