/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.deadline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.deadline.model.FleetAmountCapabilitiesCopier;
import software.amazon.awssdk.services.deadline.model.FleetAmountCapability;
import software.amazon.awssdk.services.deadline.model.FleetAttributeCapabilitiesCopier;
import software.amazon.awssdk.services.deadline.model.FleetAttributeCapability;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FleetCapabilities
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FleetCapabilities> {
    private static final SdkField<List<FleetAmountCapability>> AMOUNTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("amounts").getter(FleetCapabilities.getter(FleetCapabilities::amounts)).setter(FleetCapabilities.setter(Builder::amounts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("amounts").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FleetAmountCapability::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<FleetAttributeCapability>> ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("attributes").getter(FleetCapabilities.getter(FleetCapabilities::attributes)).setter(FleetCapabilities.setter(Builder::attributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attributes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FleetAttributeCapability::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AMOUNTS_FIELD, ATTRIBUTES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = FleetCapabilities.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<FleetAmountCapability> amounts;
    private final List<FleetAttributeCapability> attributes;

    private FleetCapabilities(BuilderImpl builder) {
        this.amounts = builder.amounts;
        this.attributes = builder.attributes;
    }

    public final boolean hasAmounts() {
        return this.amounts != null && !(this.amounts instanceof SdkAutoConstructList);
    }

    public final List<FleetAmountCapability> amounts() {
        return this.amounts;
    }

    public final boolean hasAttributes() {
        return this.attributes != null && !(this.attributes instanceof SdkAutoConstructList);
    }

    public final List<FleetAttributeCapability> attributes() {
        return this.attributes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAmounts() ? this.amounts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAttributes() ? this.attributes() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FleetCapabilities)) {
            return false;
        }
        FleetCapabilities other = (FleetCapabilities)obj;
        return this.hasAmounts() == other.hasAmounts() && Objects.equals(this.amounts(), other.amounts()) && this.hasAttributes() == other.hasAttributes() && Objects.equals(this.attributes(), other.attributes());
    }

    public final String toString() {
        return ToString.builder((String)"FleetCapabilities").add("Amounts", this.hasAmounts() ? this.amounts() : null).add("Attributes", this.hasAttributes() ? this.attributes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "amounts": {
                return Optional.ofNullable(clazz.cast(this.amounts()));
            }
            case "attributes": {
                return Optional.ofNullable(clazz.cast(this.attributes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("amounts", AMOUNTS_FIELD);
        map.put("attributes", ATTRIBUTES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FleetCapabilities, T> g) {
        return obj -> g.apply((FleetCapabilities)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<FleetAmountCapability> amounts = DefaultSdkAutoConstructList.getInstance();
        private List<FleetAttributeCapability> attributes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(FleetCapabilities model) {
            this.amounts(model.amounts);
            this.attributes(model.attributes);
        }

        public final List<FleetAmountCapability.Builder> getAmounts() {
            List<FleetAmountCapability.Builder> result = FleetAmountCapabilitiesCopier.copyToBuilder(this.amounts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAmounts(Collection<FleetAmountCapability.BuilderImpl> amounts) {
            this.amounts = FleetAmountCapabilitiesCopier.copyFromBuilder(amounts);
        }

        @Override
        public final Builder amounts(Collection<FleetAmountCapability> amounts) {
            this.amounts = FleetAmountCapabilitiesCopier.copy(amounts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder amounts(FleetAmountCapability ... amounts) {
            this.amounts(Arrays.asList(amounts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder amounts(Consumer<FleetAmountCapability.Builder> ... amounts) {
            this.amounts(Stream.of(amounts).map(c -> (FleetAmountCapability)((FleetAmountCapability.Builder)FleetAmountCapability.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<FleetAttributeCapability.Builder> getAttributes() {
            List<FleetAttributeCapability.Builder> result = FleetAttributeCapabilitiesCopier.copyToBuilder(this.attributes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAttributes(Collection<FleetAttributeCapability.BuilderImpl> attributes) {
            this.attributes = FleetAttributeCapabilitiesCopier.copyFromBuilder(attributes);
        }

        @Override
        public final Builder attributes(Collection<FleetAttributeCapability> attributes) {
            this.attributes = FleetAttributeCapabilitiesCopier.copy(attributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributes(FleetAttributeCapability ... attributes) {
            this.attributes(Arrays.asList(attributes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributes(Consumer<FleetAttributeCapability.Builder> ... attributes) {
            this.attributes(Stream.of(attributes).map(c -> (FleetAttributeCapability)((FleetAttributeCapability.Builder)FleetAttributeCapability.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public FleetCapabilities build() {
            return new FleetCapabilities(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FleetCapabilities> {
        public Builder amounts(Collection<FleetAmountCapability> var1);

        public Builder amounts(FleetAmountCapability ... var1);

        public Builder amounts(Consumer<FleetAmountCapability.Builder> ... var1);

        public Builder attributes(Collection<FleetAttributeCapability> var1);

        public Builder attributes(FleetAttributeCapability ... var1);

        public Builder attributes(Consumer<FleetAttributeCapability.Builder> ... var1);
    }
}

