/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.deadline.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.deadline.model.DeadlineRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateLimitRequest
extends DeadlineRequest
implements ToCopyableBuilder<Builder, CreateLimitRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(CreateLimitRequest.getter(CreateLimitRequest::clientToken)).setter(CreateLimitRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("X-Amz-Client-Token").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("displayName").getter(CreateLimitRequest.getter(CreateLimitRequest::displayName)).setter(CreateLimitRequest.setter(Builder::displayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()}).build();
    private static final SdkField<String> AMOUNT_REQUIREMENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("amountRequirementName").getter(CreateLimitRequest.getter(CreateLimitRequest::amountRequirementName)).setter(CreateLimitRequest.setter(Builder::amountRequirementName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("amountRequirementName").build()}).build();
    private static final SdkField<Integer> MAX_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxCount").getter(CreateLimitRequest.getter(CreateLimitRequest::maxCount)).setter(CreateLimitRequest.setter(Builder::maxCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxCount").build()}).build();
    private static final SdkField<String> FARM_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("farmId").getter(CreateLimitRequest.getter(CreateLimitRequest::farmId)).setter(CreateLimitRequest.setter(Builder::farmId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("farmId").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(CreateLimitRequest.getter(CreateLimitRequest::description)).setter(CreateLimitRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD, DISPLAY_NAME_FIELD, AMOUNT_REQUIREMENT_NAME_FIELD, MAX_COUNT_FIELD, FARM_ID_FIELD, DESCRIPTION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateLimitRequest.memberNameToFieldInitializer();
    private final String clientToken;
    private final String displayName;
    private final String amountRequirementName;
    private final Integer maxCount;
    private final String farmId;
    private final String description;

    private CreateLimitRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.displayName = builder.displayName;
        this.amountRequirementName = builder.amountRequirementName;
        this.maxCount = builder.maxCount;
        this.farmId = builder.farmId;
        this.description = builder.description;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String displayName() {
        return this.displayName;
    }

    public final String amountRequirementName() {
        return this.amountRequirementName;
    }

    public final Integer maxCount() {
        return this.maxCount;
    }

    public final String farmId() {
        return this.farmId;
    }

    public final String description() {
        return this.description;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.amountRequirementName());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.farmId());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateLimitRequest)) {
            return false;
        }
        CreateLimitRequest other = (CreateLimitRequest)((Object)obj);
        return Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.displayName(), other.displayName()) && Objects.equals(this.amountRequirementName(), other.amountRequirementName()) && Objects.equals(this.maxCount(), other.maxCount()) && Objects.equals(this.farmId(), other.farmId()) && Objects.equals(this.description(), other.description());
    }

    public final String toString() {
        return ToString.builder((String)"CreateLimitRequest").add("ClientToken", (Object)this.clientToken()).add("DisplayName", (Object)this.displayName()).add("AmountRequirementName", (Object)this.amountRequirementName()).add("MaxCount", (Object)this.maxCount()).add("FarmId", (Object)this.farmId()).add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "displayName": {
                return Optional.ofNullable(clazz.cast(this.displayName()));
            }
            case "amountRequirementName": {
                return Optional.ofNullable(clazz.cast(this.amountRequirementName()));
            }
            case "maxCount": {
                return Optional.ofNullable(clazz.cast(this.maxCount()));
            }
            case "farmId": {
                return Optional.ofNullable(clazz.cast(this.farmId()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("X-Amz-Client-Token", CLIENT_TOKEN_FIELD);
        map.put("displayName", DISPLAY_NAME_FIELD);
        map.put("amountRequirementName", AMOUNT_REQUIREMENT_NAME_FIELD);
        map.put("maxCount", MAX_COUNT_FIELD);
        map.put("farmId", FARM_ID_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateLimitRequest, T> g) {
        return obj -> g.apply((CreateLimitRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DeadlineRequest.BuilderImpl
    implements Builder {
        private String clientToken;
        private String displayName;
        private String amountRequirementName;
        private Integer maxCount;
        private String farmId;
        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateLimitRequest model) {
            super(model);
            this.clientToken(model.clientToken);
            this.displayName(model.displayName);
            this.amountRequirementName(model.amountRequirementName);
            this.maxCount(model.maxCount);
            this.farmId(model.farmId);
            this.description(model.description);
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final String getAmountRequirementName() {
            return this.amountRequirementName;
        }

        public final void setAmountRequirementName(String amountRequirementName) {
            this.amountRequirementName = amountRequirementName;
        }

        @Override
        public final Builder amountRequirementName(String amountRequirementName) {
            this.amountRequirementName = amountRequirementName;
            return this;
        }

        public final Integer getMaxCount() {
            return this.maxCount;
        }

        public final void setMaxCount(Integer maxCount) {
            this.maxCount = maxCount;
        }

        @Override
        public final Builder maxCount(Integer maxCount) {
            this.maxCount = maxCount;
            return this;
        }

        public final String getFarmId() {
            return this.farmId;
        }

        public final void setFarmId(String farmId) {
            this.farmId = farmId;
        }

        @Override
        public final Builder farmId(String farmId) {
            this.farmId = farmId;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateLimitRequest build() {
            return new CreateLimitRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends DeadlineRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateLimitRequest> {
        public Builder clientToken(String var1);

        public Builder displayName(String var1);

        public Builder amountRequirementName(String var1);

        public Builder maxCount(Integer var1);

        public Builder farmId(String var1);

        public Builder description(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

