/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.deadline.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.deadline.DeadlineAsyncClient;
import software.amazon.awssdk.services.deadline.internal.UserAgentUtils;
import software.amazon.awssdk.services.deadline.model.ListStorageProfilesRequest;
import software.amazon.awssdk.services.deadline.model.ListStorageProfilesResponse;
import software.amazon.awssdk.services.deadline.model.StorageProfileSummary;

public class ListStorageProfilesPublisher
implements SdkPublisher<ListStorageProfilesResponse> {
    private final DeadlineAsyncClient client;
    private final ListStorageProfilesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListStorageProfilesPublisher(DeadlineAsyncClient client, ListStorageProfilesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListStorageProfilesPublisher(DeadlineAsyncClient client, ListStorageProfilesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListStorageProfilesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListStorageProfilesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<StorageProfileSummary> storageProfiles() {
        Function<ListStorageProfilesResponse, Iterator> getIterator = response -> {
            if (response != null && response.storageProfiles() != null) {
                return response.storageProfiles().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListStorageProfilesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListStorageProfilesResponseFetcher
    implements AsyncPageFetcher<ListStorageProfilesResponse> {
        private ListStorageProfilesResponseFetcher() {
        }

        public boolean hasNextPage(ListStorageProfilesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListStorageProfilesResponse> nextPage(ListStorageProfilesResponse previousPage) {
            if (previousPage == null) {
                return ListStorageProfilesPublisher.this.client.listStorageProfiles(ListStorageProfilesPublisher.this.firstRequest);
            }
            return ListStorageProfilesPublisher.this.client.listStorageProfiles((ListStorageProfilesRequest)((Object)ListStorageProfilesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

