/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.deadline.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.deadline.DeadlineAsyncClient;
import software.amazon.awssdk.services.deadline.internal.UserAgentUtils;
import software.amazon.awssdk.services.deadline.model.ListQueueLimitAssociationsRequest;
import software.amazon.awssdk.services.deadline.model.ListQueueLimitAssociationsResponse;
import software.amazon.awssdk.services.deadline.model.QueueLimitAssociationSummary;

public class ListQueueLimitAssociationsPublisher
implements SdkPublisher<ListQueueLimitAssociationsResponse> {
    private final DeadlineAsyncClient client;
    private final ListQueueLimitAssociationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListQueueLimitAssociationsPublisher(DeadlineAsyncClient client, ListQueueLimitAssociationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListQueueLimitAssociationsPublisher(DeadlineAsyncClient client, ListQueueLimitAssociationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListQueueLimitAssociationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListQueueLimitAssociationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<QueueLimitAssociationSummary> queueLimitAssociations() {
        Function<ListQueueLimitAssociationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.queueLimitAssociations() != null) {
                return response.queueLimitAssociations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListQueueLimitAssociationsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListQueueLimitAssociationsResponseFetcher
    implements AsyncPageFetcher<ListQueueLimitAssociationsResponse> {
        private ListQueueLimitAssociationsResponseFetcher() {
        }

        public boolean hasNextPage(ListQueueLimitAssociationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListQueueLimitAssociationsResponse> nextPage(ListQueueLimitAssociationsResponse previousPage) {
            if (previousPage == null) {
                return ListQueueLimitAssociationsPublisher.this.client.listQueueLimitAssociations(ListQueueLimitAssociationsPublisher.this.firstRequest);
            }
            return ListQueueLimitAssociationsPublisher.this.client.listQueueLimitAssociations((ListQueueLimitAssociationsRequest)((Object)ListQueueLimitAssociationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

