/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.deadline.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.deadline.DeadlineAsyncClient;
import software.amazon.awssdk.services.deadline.internal.UserAgentUtils;
import software.amazon.awssdk.services.deadline.model.JobMember;
import software.amazon.awssdk.services.deadline.model.ListJobMembersRequest;
import software.amazon.awssdk.services.deadline.model.ListJobMembersResponse;

public class ListJobMembersPublisher
implements SdkPublisher<ListJobMembersResponse> {
    private final DeadlineAsyncClient client;
    private final ListJobMembersRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListJobMembersPublisher(DeadlineAsyncClient client, ListJobMembersRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListJobMembersPublisher(DeadlineAsyncClient client, ListJobMembersRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListJobMembersResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListJobMembersResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<JobMember> members() {
        Function<ListJobMembersResponse, Iterator> getIterator = response -> {
            if (response != null && response.members() != null) {
                return response.members().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListJobMembersResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListJobMembersResponseFetcher
    implements AsyncPageFetcher<ListJobMembersResponse> {
        private ListJobMembersResponseFetcher() {
        }

        public boolean hasNextPage(ListJobMembersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListJobMembersResponse> nextPage(ListJobMembersResponse previousPage) {
            if (previousPage == null) {
                return ListJobMembersPublisher.this.client.listJobMembers(ListJobMembersPublisher.this.firstRequest);
            }
            return ListJobMembersPublisher.this.client.listJobMembers((ListJobMembersRequest)((Object)ListJobMembersPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

