/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.deadline.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.deadline.model.CompletedStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdatedSessionActionInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, UpdatedSessionActionInfo> {
    private static final SdkField<String> COMPLETED_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("completedStatus").getter(UpdatedSessionActionInfo.getter(UpdatedSessionActionInfo::completedStatusAsString)).setter(UpdatedSessionActionInfo.setter(Builder::completedStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("completedStatus").build()}).build();
    private static final SdkField<Integer> PROCESS_EXIT_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("processExitCode").getter(UpdatedSessionActionInfo.getter(UpdatedSessionActionInfo::processExitCode)).setter(UpdatedSessionActionInfo.setter(Builder::processExitCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("processExitCode").build()}).build();
    private static final SdkField<String> PROGRESS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("progressMessage").getter(UpdatedSessionActionInfo.getter(UpdatedSessionActionInfo::progressMessage)).setter(UpdatedSessionActionInfo.setter(Builder::progressMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("progressMessage").build()}).build();
    private static final SdkField<Instant> STARTED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("startedAt").getter(UpdatedSessionActionInfo.getter(UpdatedSessionActionInfo::startedAt)).setter(UpdatedSessionActionInfo.setter(Builder::startedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> ENDED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("endedAt").getter(UpdatedSessionActionInfo.getter(UpdatedSessionActionInfo::endedAt)).setter(UpdatedSessionActionInfo.setter(Builder::endedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updatedAt").getter(UpdatedSessionActionInfo.getter(UpdatedSessionActionInfo::updatedAt)).setter(UpdatedSessionActionInfo.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Float> PROGRESS_PERCENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).memberName("progressPercent").getter(UpdatedSessionActionInfo.getter(UpdatedSessionActionInfo::progressPercent)).setter(UpdatedSessionActionInfo.setter(Builder::progressPercent)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("progressPercent").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPLETED_STATUS_FIELD, PROCESS_EXIT_CODE_FIELD, PROGRESS_MESSAGE_FIELD, STARTED_AT_FIELD, ENDED_AT_FIELD, UPDATED_AT_FIELD, PROGRESS_PERCENT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdatedSessionActionInfo.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String completedStatus;
    private final Integer processExitCode;
    private final String progressMessage;
    private final Instant startedAt;
    private final Instant endedAt;
    private final Instant updatedAt;
    private final Float progressPercent;

    private UpdatedSessionActionInfo(BuilderImpl builder) {
        this.completedStatus = builder.completedStatus;
        this.processExitCode = builder.processExitCode;
        this.progressMessage = builder.progressMessage;
        this.startedAt = builder.startedAt;
        this.endedAt = builder.endedAt;
        this.updatedAt = builder.updatedAt;
        this.progressPercent = builder.progressPercent;
    }

    public final CompletedStatus completedStatus() {
        return CompletedStatus.fromValue(this.completedStatus);
    }

    public final String completedStatusAsString() {
        return this.completedStatus;
    }

    public final Integer processExitCode() {
        return this.processExitCode;
    }

    public final String progressMessage() {
        return this.progressMessage;
    }

    public final Instant startedAt() {
        return this.startedAt;
    }

    public final Instant endedAt() {
        return this.endedAt;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public final Float progressPercent() {
        return this.progressPercent;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.completedStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.processExitCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.progressMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.startedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.endedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.progressPercent());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdatedSessionActionInfo)) {
            return false;
        }
        UpdatedSessionActionInfo other = (UpdatedSessionActionInfo)obj;
        return Objects.equals(this.completedStatusAsString(), other.completedStatusAsString()) && Objects.equals(this.processExitCode(), other.processExitCode()) && Objects.equals(this.progressMessage(), other.progressMessage()) && Objects.equals(this.startedAt(), other.startedAt()) && Objects.equals(this.endedAt(), other.endedAt()) && Objects.equals(this.updatedAt(), other.updatedAt()) && Objects.equals(this.progressPercent(), other.progressPercent());
    }

    public final String toString() {
        return ToString.builder((String)"UpdatedSessionActionInfo").add("CompletedStatus", (Object)this.completedStatusAsString()).add("ProcessExitCode", (Object)this.processExitCode()).add("ProgressMessage", (Object)(this.progressMessage() == null ? null : "*** Sensitive Data Redacted ***")).add("StartedAt", (Object)this.startedAt()).add("EndedAt", (Object)this.endedAt()).add("UpdatedAt", (Object)this.updatedAt()).add("ProgressPercent", (Object)this.progressPercent()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "completedStatus": {
                return Optional.ofNullable(clazz.cast(this.completedStatusAsString()));
            }
            case "processExitCode": {
                return Optional.ofNullable(clazz.cast(this.processExitCode()));
            }
            case "progressMessage": {
                return Optional.ofNullable(clazz.cast(this.progressMessage()));
            }
            case "startedAt": {
                return Optional.ofNullable(clazz.cast(this.startedAt()));
            }
            case "endedAt": {
                return Optional.ofNullable(clazz.cast(this.endedAt()));
            }
            case "updatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
            case "progressPercent": {
                return Optional.ofNullable(clazz.cast(this.progressPercent()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("completedStatus", COMPLETED_STATUS_FIELD);
        map.put("processExitCode", PROCESS_EXIT_CODE_FIELD);
        map.put("progressMessage", PROGRESS_MESSAGE_FIELD);
        map.put("startedAt", STARTED_AT_FIELD);
        map.put("endedAt", ENDED_AT_FIELD);
        map.put("updatedAt", UPDATED_AT_FIELD);
        map.put("progressPercent", PROGRESS_PERCENT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdatedSessionActionInfo, T> g) {
        return obj -> g.apply((UpdatedSessionActionInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String completedStatus;
        private Integer processExitCode;
        private String progressMessage;
        private Instant startedAt;
        private Instant endedAt;
        private Instant updatedAt;
        private Float progressPercent;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdatedSessionActionInfo model) {
            this.completedStatus(model.completedStatus);
            this.processExitCode(model.processExitCode);
            this.progressMessage(model.progressMessage);
            this.startedAt(model.startedAt);
            this.endedAt(model.endedAt);
            this.updatedAt(model.updatedAt);
            this.progressPercent(model.progressPercent);
        }

        public final String getCompletedStatus() {
            return this.completedStatus;
        }

        public final void setCompletedStatus(String completedStatus) {
            this.completedStatus = completedStatus;
        }

        @Override
        public final Builder completedStatus(String completedStatus) {
            this.completedStatus = completedStatus;
            return this;
        }

        @Override
        public final Builder completedStatus(CompletedStatus completedStatus) {
            this.completedStatus(completedStatus == null ? null : completedStatus.toString());
            return this;
        }

        public final Integer getProcessExitCode() {
            return this.processExitCode;
        }

        public final void setProcessExitCode(Integer processExitCode) {
            this.processExitCode = processExitCode;
        }

        @Override
        public final Builder processExitCode(Integer processExitCode) {
            this.processExitCode = processExitCode;
            return this;
        }

        public final String getProgressMessage() {
            return this.progressMessage;
        }

        public final void setProgressMessage(String progressMessage) {
            this.progressMessage = progressMessage;
        }

        @Override
        public final Builder progressMessage(String progressMessage) {
            this.progressMessage = progressMessage;
            return this;
        }

        public final Instant getStartedAt() {
            return this.startedAt;
        }

        public final void setStartedAt(Instant startedAt) {
            this.startedAt = startedAt;
        }

        @Override
        public final Builder startedAt(Instant startedAt) {
            this.startedAt = startedAt;
            return this;
        }

        public final Instant getEndedAt() {
            return this.endedAt;
        }

        public final void setEndedAt(Instant endedAt) {
            this.endedAt = endedAt;
        }

        @Override
        public final Builder endedAt(Instant endedAt) {
            this.endedAt = endedAt;
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final Float getProgressPercent() {
            return this.progressPercent;
        }

        public final void setProgressPercent(Float progressPercent) {
            this.progressPercent = progressPercent;
        }

        @Override
        public final Builder progressPercent(Float progressPercent) {
            this.progressPercent = progressPercent;
            return this;
        }

        public UpdatedSessionActionInfo build() {
            return new UpdatedSessionActionInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, UpdatedSessionActionInfo> {
        public Builder completedStatus(String var1);

        public Builder completedStatus(CompletedStatus var1);

        public Builder processExitCode(Integer var1);

        public Builder progressMessage(String var1);

        public Builder startedAt(Instant var1);

        public Builder endedAt(Instant var1);

        public Builder updatedAt(Instant var1);

        public Builder progressPercent(Float var1);
    }
}

