/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.deadline.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.deadline.model.DeadlineResponse;
import software.amazon.awssdk.services.deadline.model.LimitSummariesCopier;
import software.amazon.awssdk.services.deadline.model.LimitSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListLimitsResponse
extends DeadlineResponse
implements ToCopyableBuilder<Builder, ListLimitsResponse> {
    private static final SdkField<List<LimitSummary>> LIMITS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("limits").getter(ListLimitsResponse.getter(ListLimitsResponse::limits)).setter(ListLimitsResponse.setter(Builder::limits)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("limits").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LimitSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListLimitsResponse.getter(ListLimitsResponse::nextToken)).setter(ListLimitsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LIMITS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListLimitsResponse.memberNameToFieldInitializer();
    private final List<LimitSummary> limits;
    private final String nextToken;

    private ListLimitsResponse(BuilderImpl builder) {
        super(builder);
        this.limits = builder.limits;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasLimits() {
        return this.limits != null && !(this.limits instanceof SdkAutoConstructList);
    }

    public final List<LimitSummary> limits() {
        return this.limits;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLimits() ? this.limits() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListLimitsResponse)) {
            return false;
        }
        ListLimitsResponse other = (ListLimitsResponse)((Object)obj);
        return this.hasLimits() == other.hasLimits() && Objects.equals(this.limits(), other.limits()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListLimitsResponse").add("Limits", this.hasLimits() ? this.limits() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "limits": {
                return Optional.ofNullable(clazz.cast(this.limits()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("limits", LIMITS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListLimitsResponse, T> g) {
        return obj -> g.apply((ListLimitsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DeadlineResponse.BuilderImpl
    implements Builder {
        private List<LimitSummary> limits = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListLimitsResponse model) {
            super(model);
            this.limits(model.limits);
            this.nextToken(model.nextToken);
        }

        public final List<LimitSummary.Builder> getLimits() {
            List<LimitSummary.Builder> result = LimitSummariesCopier.copyToBuilder(this.limits);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLimits(Collection<LimitSummary.BuilderImpl> limits) {
            this.limits = LimitSummariesCopier.copyFromBuilder(limits);
        }

        @Override
        public final Builder limits(Collection<LimitSummary> limits) {
            this.limits = LimitSummariesCopier.copy(limits);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder limits(LimitSummary ... limits) {
            this.limits(Arrays.asList(limits));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder limits(Consumer<LimitSummary.Builder> ... limits) {
            this.limits(Stream.of(limits).map(c -> (LimitSummary)((LimitSummary.Builder)LimitSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListLimitsResponse build() {
            return new ListLimitsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends DeadlineResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListLimitsResponse> {
        public Builder limits(Collection<LimitSummary> var1);

        public Builder limits(LimitSummary ... var1);

        public Builder limits(Consumer<LimitSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

