/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.deadline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.deadline.model.IpV4AddressesCopier;
import software.amazon.awssdk.services.deadline.model.IpV6AddressesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IpAddresses
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, IpAddresses> {
    private static final SdkField<List<String>> IP_V4_ADDRESSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ipV4Addresses").getter(IpAddresses.getter(IpAddresses::ipV4Addresses)).setter(IpAddresses.setter(Builder::ipV4Addresses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ipV4Addresses").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> IP_V6_ADDRESSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ipV6Addresses").getter(IpAddresses.getter(IpAddresses::ipV6Addresses)).setter(IpAddresses.setter(Builder::ipV6Addresses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ipV6Addresses").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IP_V4_ADDRESSES_FIELD, IP_V6_ADDRESSES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = IpAddresses.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> ipV4Addresses;
    private final List<String> ipV6Addresses;

    private IpAddresses(BuilderImpl builder) {
        this.ipV4Addresses = builder.ipV4Addresses;
        this.ipV6Addresses = builder.ipV6Addresses;
    }

    public final boolean hasIpV4Addresses() {
        return this.ipV4Addresses != null && !(this.ipV4Addresses instanceof SdkAutoConstructList);
    }

    public final List<String> ipV4Addresses() {
        return this.ipV4Addresses;
    }

    public final boolean hasIpV6Addresses() {
        return this.ipV6Addresses != null && !(this.ipV6Addresses instanceof SdkAutoConstructList);
    }

    public final List<String> ipV6Addresses() {
        return this.ipV6Addresses;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIpV4Addresses() ? this.ipV4Addresses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIpV6Addresses() ? this.ipV6Addresses() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IpAddresses)) {
            return false;
        }
        IpAddresses other = (IpAddresses)obj;
        return this.hasIpV4Addresses() == other.hasIpV4Addresses() && Objects.equals(this.ipV4Addresses(), other.ipV4Addresses()) && this.hasIpV6Addresses() == other.hasIpV6Addresses() && Objects.equals(this.ipV6Addresses(), other.ipV6Addresses());
    }

    public final String toString() {
        return ToString.builder((String)"IpAddresses").add("IpV4Addresses", this.hasIpV4Addresses() ? this.ipV4Addresses() : null).add("IpV6Addresses", this.hasIpV6Addresses() ? this.ipV6Addresses() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ipV4Addresses": {
                return Optional.ofNullable(clazz.cast(this.ipV4Addresses()));
            }
            case "ipV6Addresses": {
                return Optional.ofNullable(clazz.cast(this.ipV6Addresses()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<String>>> map = new HashMap<String, SdkField<List<String>>>();
        map.put("ipV4Addresses", IP_V4_ADDRESSES_FIELD);
        map.put("ipV6Addresses", IP_V6_ADDRESSES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IpAddresses, T> g) {
        return obj -> g.apply((IpAddresses)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> ipV4Addresses = DefaultSdkAutoConstructList.getInstance();
        private List<String> ipV6Addresses = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(IpAddresses model) {
            this.ipV4Addresses(model.ipV4Addresses);
            this.ipV6Addresses(model.ipV6Addresses);
        }

        public final Collection<String> getIpV4Addresses() {
            if (this.ipV4Addresses instanceof SdkAutoConstructList) {
                return null;
            }
            return this.ipV4Addresses;
        }

        public final void setIpV4Addresses(Collection<String> ipV4Addresses) {
            this.ipV4Addresses = IpV4AddressesCopier.copy(ipV4Addresses);
        }

        @Override
        public final Builder ipV4Addresses(Collection<String> ipV4Addresses) {
            this.ipV4Addresses = IpV4AddressesCopier.copy(ipV4Addresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipV4Addresses(String ... ipV4Addresses) {
            this.ipV4Addresses(Arrays.asList(ipV4Addresses));
            return this;
        }

        public final Collection<String> getIpV6Addresses() {
            if (this.ipV6Addresses instanceof SdkAutoConstructList) {
                return null;
            }
            return this.ipV6Addresses;
        }

        public final void setIpV6Addresses(Collection<String> ipV6Addresses) {
            this.ipV6Addresses = IpV6AddressesCopier.copy(ipV6Addresses);
        }

        @Override
        public final Builder ipV6Addresses(Collection<String> ipV6Addresses) {
            this.ipV6Addresses = IpV6AddressesCopier.copy(ipV6Addresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipV6Addresses(String ... ipV6Addresses) {
            this.ipV6Addresses(Arrays.asList(ipV6Addresses));
            return this;
        }

        public IpAddresses build() {
            return new IpAddresses(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, IpAddresses> {
        public Builder ipV4Addresses(Collection<String> var1);

        public Builder ipV4Addresses(String ... var1);

        public Builder ipV6Addresses(Collection<String> var1);

        public Builder ipV6Addresses(String ... var1);
    }
}

