/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.deadline.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum CompletedStatus {
    SUCCEEDED("SUCCEEDED"),
    FAILED("FAILED"),
    INTERRUPTED("INTERRUPTED"),
    CANCELED("CANCELED"),
    NEVER_ATTEMPTED("NEVER_ATTEMPTED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, CompletedStatus> VALUE_MAP;
    private final String value;

    private CompletedStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static CompletedStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<CompletedStatus> knownValues() {
        EnumSet<CompletedStatus> knownValues = EnumSet.allOf(CompletedStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(CompletedStatus.class, CompletedStatus::toString);
    }
}

