/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.datazone.DataZoneAsyncClient;
import software.amazon.awssdk.services.datazone.internal.UserAgentUtils;
import software.amazon.awssdk.services.datazone.model.ListSubscriptionTargetsRequest;
import software.amazon.awssdk.services.datazone.model.ListSubscriptionTargetsResponse;
import software.amazon.awssdk.services.datazone.model.SubscriptionTargetSummary;

public class ListSubscriptionTargetsPublisher
implements SdkPublisher<ListSubscriptionTargetsResponse> {
    private final DataZoneAsyncClient client;
    private final ListSubscriptionTargetsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListSubscriptionTargetsPublisher(DataZoneAsyncClient client, ListSubscriptionTargetsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListSubscriptionTargetsPublisher(DataZoneAsyncClient client, ListSubscriptionTargetsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListSubscriptionTargetsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListSubscriptionTargetsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<SubscriptionTargetSummary> items() {
        Function<ListSubscriptionTargetsResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListSubscriptionTargetsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListSubscriptionTargetsResponseFetcher
    implements AsyncPageFetcher<ListSubscriptionTargetsResponse> {
        private ListSubscriptionTargetsResponseFetcher() {
        }

        public boolean hasNextPage(ListSubscriptionTargetsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListSubscriptionTargetsResponse> nextPage(ListSubscriptionTargetsResponse previousPage) {
            if (previousPage == null) {
                return ListSubscriptionTargetsPublisher.this.client.listSubscriptionTargets(ListSubscriptionTargetsPublisher.this.firstRequest);
            }
            return ListSubscriptionTargetsPublisher.this.client.listSubscriptionTargets((ListSubscriptionTargetsRequest)((Object)ListSubscriptionTargetsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

