/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum TimeSeriesEntityType {
    ASSET("ASSET"),
    LISTING("LISTING"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, TimeSeriesEntityType> VALUE_MAP;
    private final String value;

    private TimeSeriesEntityType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static TimeSeriesEntityType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<TimeSeriesEntityType> knownValues() {
        EnumSet<TimeSeriesEntityType> knownValues = EnumSet.allOf(TimeSeriesEntityType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(TimeSeriesEntityType.class, TimeSeriesEntityType::toString);
    }
}

