/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.datazone.model.ConnectionStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class S3PropertiesOutput
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, S3PropertiesOutput> {
    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("errorMessage").getter(S3PropertiesOutput.getter(S3PropertiesOutput::errorMessage)).setter(S3PropertiesOutput.setter(Builder::errorMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorMessage").build()}).build();
    private static final SdkField<String> S3_ACCESS_GRANT_LOCATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("s3AccessGrantLocationId").getter(S3PropertiesOutput.getter(S3PropertiesOutput::s3AccessGrantLocationId)).setter(S3PropertiesOutput.setter(Builder::s3AccessGrantLocationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3AccessGrantLocationId").build()}).build();
    private static final SdkField<String> S3_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("s3Uri").getter(S3PropertiesOutput.getter(S3PropertiesOutput::s3Uri)).setter(S3PropertiesOutput.setter(Builder::s3Uri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3Uri").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(S3PropertiesOutput.getter(S3PropertiesOutput::statusAsString)).setter(S3PropertiesOutput.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ERROR_MESSAGE_FIELD, S3_ACCESS_GRANT_LOCATION_ID_FIELD, S3_URI_FIELD, STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = S3PropertiesOutput.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String errorMessage;
    private final String s3AccessGrantLocationId;
    private final String s3Uri;
    private final String status;

    private S3PropertiesOutput(BuilderImpl builder) {
        this.errorMessage = builder.errorMessage;
        this.s3AccessGrantLocationId = builder.s3AccessGrantLocationId;
        this.s3Uri = builder.s3Uri;
        this.status = builder.status;
    }

    public final String errorMessage() {
        return this.errorMessage;
    }

    public final String s3AccessGrantLocationId() {
        return this.s3AccessGrantLocationId;
    }

    public final String s3Uri() {
        return this.s3Uri;
    }

    public final ConnectionStatus status() {
        return ConnectionStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.errorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3AccessGrantLocationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Uri());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3PropertiesOutput)) {
            return false;
        }
        S3PropertiesOutput other = (S3PropertiesOutput)obj;
        return Objects.equals(this.errorMessage(), other.errorMessage()) && Objects.equals(this.s3AccessGrantLocationId(), other.s3AccessGrantLocationId()) && Objects.equals(this.s3Uri(), other.s3Uri()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"S3PropertiesOutput").add("ErrorMessage", (Object)this.errorMessage()).add("S3AccessGrantLocationId", (Object)this.s3AccessGrantLocationId()).add("S3Uri", (Object)this.s3Uri()).add("Status", (Object)this.statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "errorMessage": {
                return Optional.ofNullable(clazz.cast(this.errorMessage()));
            }
            case "s3AccessGrantLocationId": {
                return Optional.ofNullable(clazz.cast(this.s3AccessGrantLocationId()));
            }
            case "s3Uri": {
                return Optional.ofNullable(clazz.cast(this.s3Uri()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("errorMessage", ERROR_MESSAGE_FIELD);
        map.put("s3AccessGrantLocationId", S3_ACCESS_GRANT_LOCATION_ID_FIELD);
        map.put("s3Uri", S3_URI_FIELD);
        map.put("status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<S3PropertiesOutput, T> g) {
        return obj -> g.apply((S3PropertiesOutput)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String errorMessage;
        private String s3AccessGrantLocationId;
        private String s3Uri;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(S3PropertiesOutput model) {
            this.errorMessage(model.errorMessage);
            this.s3AccessGrantLocationId(model.s3AccessGrantLocationId);
            this.s3Uri(model.s3Uri);
            this.status(model.status);
        }

        public final String getErrorMessage() {
            return this.errorMessage;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final String getS3AccessGrantLocationId() {
            return this.s3AccessGrantLocationId;
        }

        public final void setS3AccessGrantLocationId(String s3AccessGrantLocationId) {
            this.s3AccessGrantLocationId = s3AccessGrantLocationId;
        }

        @Override
        public final Builder s3AccessGrantLocationId(String s3AccessGrantLocationId) {
            this.s3AccessGrantLocationId = s3AccessGrantLocationId;
            return this;
        }

        public final String getS3Uri() {
            return this.s3Uri;
        }

        public final void setS3Uri(String s3Uri) {
            this.s3Uri = s3Uri;
        }

        @Override
        public final Builder s3Uri(String s3Uri) {
            this.s3Uri = s3Uri;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ConnectionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public S3PropertiesOutput build() {
            return new S3PropertiesOutput(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, S3PropertiesOutput> {
        public Builder errorMessage(String var1);

        public Builder s3AccessGrantLocationId(String var1);

        public Builder s3Uri(String var1);

        public Builder status(String var1);

        public Builder status(ConnectionStatus var1);
    }
}

