/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DeploymentMode {
    ON_CREATE("ON_CREATE"),
    ON_DEMAND("ON_DEMAND"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DeploymentMode> VALUE_MAP;
    private final String value;

    private DeploymentMode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DeploymentMode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DeploymentMode> knownValues() {
        EnumSet<DeploymentMode> knownValues = EnumSet.allOf(DeploymentMode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DeploymentMode.class, DeploymentMode::toString);
    }
}

