/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.datazone.model.DetailedGlossaryTerm;
import software.amazon.awssdk.services.datazone.model.DetailedGlossaryTermsCopier;
import software.amazon.awssdk.services.datazone.model.TimeSeriesDataPointSummaryFormOutput;
import software.amazon.awssdk.services.datazone.model.TimeSeriesDataPointSummaryFormOutputListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AssetListing
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AssetListing> {
    private static final SdkField<String> ASSET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("assetId").getter(AssetListing.getter(AssetListing::assetId)).setter(AssetListing.setter(Builder::assetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetId").build()}).build();
    private static final SdkField<String> ASSET_REVISION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("assetRevision").getter(AssetListing.getter(AssetListing::assetRevision)).setter(AssetListing.setter(Builder::assetRevision)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetRevision").build()}).build();
    private static final SdkField<String> ASSET_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("assetType").getter(AssetListing.getter(AssetListing::assetType)).setter(AssetListing.setter(Builder::assetType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetType").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(AssetListing.getter(AssetListing::createdAt)).setter(AssetListing.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<String> FORMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("forms").getter(AssetListing.getter(AssetListing::forms)).setter(AssetListing.setter(Builder::forms)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("forms").build()}).build();
    private static final SdkField<List<DetailedGlossaryTerm>> GLOSSARY_TERMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("glossaryTerms").getter(AssetListing.getter(AssetListing::glossaryTerms)).setter(AssetListing.setter(Builder::glossaryTerms)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("glossaryTerms").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DetailedGlossaryTerm::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<TimeSeriesDataPointSummaryFormOutput>> LATEST_TIME_SERIES_DATA_POINT_FORMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("latestTimeSeriesDataPointForms").getter(AssetListing.getter(AssetListing::latestTimeSeriesDataPointForms)).setter(AssetListing.setter(Builder::latestTimeSeriesDataPointForms)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("latestTimeSeriesDataPointForms").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TimeSeriesDataPointSummaryFormOutput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> OWNING_PROJECT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("owningProjectId").getter(AssetListing.getter(AssetListing::owningProjectId)).setter(AssetListing.setter(Builder::owningProjectId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("owningProjectId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSET_ID_FIELD, ASSET_REVISION_FIELD, ASSET_TYPE_FIELD, CREATED_AT_FIELD, FORMS_FIELD, GLOSSARY_TERMS_FIELD, LATEST_TIME_SERIES_DATA_POINT_FORMS_FIELD, OWNING_PROJECT_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AssetListing.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String assetId;
    private final String assetRevision;
    private final String assetType;
    private final Instant createdAt;
    private final String forms;
    private final List<DetailedGlossaryTerm> glossaryTerms;
    private final List<TimeSeriesDataPointSummaryFormOutput> latestTimeSeriesDataPointForms;
    private final String owningProjectId;

    private AssetListing(BuilderImpl builder) {
        this.assetId = builder.assetId;
        this.assetRevision = builder.assetRevision;
        this.assetType = builder.assetType;
        this.createdAt = builder.createdAt;
        this.forms = builder.forms;
        this.glossaryTerms = builder.glossaryTerms;
        this.latestTimeSeriesDataPointForms = builder.latestTimeSeriesDataPointForms;
        this.owningProjectId = builder.owningProjectId;
    }

    public final String assetId() {
        return this.assetId;
    }

    public final String assetRevision() {
        return this.assetRevision;
    }

    public final String assetType() {
        return this.assetType;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final String forms() {
        return this.forms;
    }

    public final boolean hasGlossaryTerms() {
        return this.glossaryTerms != null && !(this.glossaryTerms instanceof SdkAutoConstructList);
    }

    public final List<DetailedGlossaryTerm> glossaryTerms() {
        return this.glossaryTerms;
    }

    public final boolean hasLatestTimeSeriesDataPointForms() {
        return this.latestTimeSeriesDataPointForms != null && !(this.latestTimeSeriesDataPointForms instanceof SdkAutoConstructList);
    }

    public final List<TimeSeriesDataPointSummaryFormOutput> latestTimeSeriesDataPointForms() {
        return this.latestTimeSeriesDataPointForms;
    }

    public final String owningProjectId() {
        return this.owningProjectId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.assetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.assetRevision());
        hashCode = 31 * hashCode + Objects.hashCode(this.assetType());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.forms());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGlossaryTerms() ? this.glossaryTerms() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLatestTimeSeriesDataPointForms() ? this.latestTimeSeriesDataPointForms() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.owningProjectId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssetListing)) {
            return false;
        }
        AssetListing other = (AssetListing)obj;
        return Objects.equals(this.assetId(), other.assetId()) && Objects.equals(this.assetRevision(), other.assetRevision()) && Objects.equals(this.assetType(), other.assetType()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.forms(), other.forms()) && this.hasGlossaryTerms() == other.hasGlossaryTerms() && Objects.equals(this.glossaryTerms(), other.glossaryTerms()) && this.hasLatestTimeSeriesDataPointForms() == other.hasLatestTimeSeriesDataPointForms() && Objects.equals(this.latestTimeSeriesDataPointForms(), other.latestTimeSeriesDataPointForms()) && Objects.equals(this.owningProjectId(), other.owningProjectId());
    }

    public final String toString() {
        return ToString.builder((String)"AssetListing").add("AssetId", (Object)this.assetId()).add("AssetRevision", (Object)this.assetRevision()).add("AssetType", (Object)this.assetType()).add("CreatedAt", (Object)this.createdAt()).add("Forms", (Object)this.forms()).add("GlossaryTerms", this.hasGlossaryTerms() ? this.glossaryTerms() : null).add("LatestTimeSeriesDataPointForms", this.hasLatestTimeSeriesDataPointForms() ? this.latestTimeSeriesDataPointForms() : null).add("OwningProjectId", (Object)this.owningProjectId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "assetId": {
                return Optional.ofNullable(clazz.cast(this.assetId()));
            }
            case "assetRevision": {
                return Optional.ofNullable(clazz.cast(this.assetRevision()));
            }
            case "assetType": {
                return Optional.ofNullable(clazz.cast(this.assetType()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "forms": {
                return Optional.ofNullable(clazz.cast(this.forms()));
            }
            case "glossaryTerms": {
                return Optional.ofNullable(clazz.cast(this.glossaryTerms()));
            }
            case "latestTimeSeriesDataPointForms": {
                return Optional.ofNullable(clazz.cast(this.latestTimeSeriesDataPointForms()));
            }
            case "owningProjectId": {
                return Optional.ofNullable(clazz.cast(this.owningProjectId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("assetId", ASSET_ID_FIELD);
        map.put("assetRevision", ASSET_REVISION_FIELD);
        map.put("assetType", ASSET_TYPE_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("forms", FORMS_FIELD);
        map.put("glossaryTerms", GLOSSARY_TERMS_FIELD);
        map.put("latestTimeSeriesDataPointForms", LATEST_TIME_SERIES_DATA_POINT_FORMS_FIELD);
        map.put("owningProjectId", OWNING_PROJECT_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AssetListing, T> g) {
        return obj -> g.apply((AssetListing)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String assetId;
        private String assetRevision;
        private String assetType;
        private Instant createdAt;
        private String forms;
        private List<DetailedGlossaryTerm> glossaryTerms = DefaultSdkAutoConstructList.getInstance();
        private List<TimeSeriesDataPointSummaryFormOutput> latestTimeSeriesDataPointForms = DefaultSdkAutoConstructList.getInstance();
        private String owningProjectId;

        private BuilderImpl() {
        }

        private BuilderImpl(AssetListing model) {
            this.assetId(model.assetId);
            this.assetRevision(model.assetRevision);
            this.assetType(model.assetType);
            this.createdAt(model.createdAt);
            this.forms(model.forms);
            this.glossaryTerms(model.glossaryTerms);
            this.latestTimeSeriesDataPointForms(model.latestTimeSeriesDataPointForms);
            this.owningProjectId(model.owningProjectId);
        }

        public final String getAssetId() {
            return this.assetId;
        }

        public final void setAssetId(String assetId) {
            this.assetId = assetId;
        }

        @Override
        public final Builder assetId(String assetId) {
            this.assetId = assetId;
            return this;
        }

        public final String getAssetRevision() {
            return this.assetRevision;
        }

        public final void setAssetRevision(String assetRevision) {
            this.assetRevision = assetRevision;
        }

        @Override
        public final Builder assetRevision(String assetRevision) {
            this.assetRevision = assetRevision;
            return this;
        }

        public final String getAssetType() {
            return this.assetType;
        }

        public final void setAssetType(String assetType) {
            this.assetType = assetType;
        }

        @Override
        public final Builder assetType(String assetType) {
            this.assetType = assetType;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getForms() {
            return this.forms;
        }

        public final void setForms(String forms) {
            this.forms = forms;
        }

        @Override
        public final Builder forms(String forms) {
            this.forms = forms;
            return this;
        }

        public final List<DetailedGlossaryTerm.Builder> getGlossaryTerms() {
            List<DetailedGlossaryTerm.Builder> result = DetailedGlossaryTermsCopier.copyToBuilder(this.glossaryTerms);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGlossaryTerms(Collection<DetailedGlossaryTerm.BuilderImpl> glossaryTerms) {
            this.glossaryTerms = DetailedGlossaryTermsCopier.copyFromBuilder(glossaryTerms);
        }

        @Override
        public final Builder glossaryTerms(Collection<DetailedGlossaryTerm> glossaryTerms) {
            this.glossaryTerms = DetailedGlossaryTermsCopier.copy(glossaryTerms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder glossaryTerms(DetailedGlossaryTerm ... glossaryTerms) {
            this.glossaryTerms(Arrays.asList(glossaryTerms));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder glossaryTerms(Consumer<DetailedGlossaryTerm.Builder> ... glossaryTerms) {
            this.glossaryTerms(Stream.of(glossaryTerms).map(c -> (DetailedGlossaryTerm)((DetailedGlossaryTerm.Builder)DetailedGlossaryTerm.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<TimeSeriesDataPointSummaryFormOutput.Builder> getLatestTimeSeriesDataPointForms() {
            List<TimeSeriesDataPointSummaryFormOutput.Builder> result = TimeSeriesDataPointSummaryFormOutputListCopier.copyToBuilder(this.latestTimeSeriesDataPointForms);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLatestTimeSeriesDataPointForms(Collection<TimeSeriesDataPointSummaryFormOutput.BuilderImpl> latestTimeSeriesDataPointForms) {
            this.latestTimeSeriesDataPointForms = TimeSeriesDataPointSummaryFormOutputListCopier.copyFromBuilder(latestTimeSeriesDataPointForms);
        }

        @Override
        public final Builder latestTimeSeriesDataPointForms(Collection<TimeSeriesDataPointSummaryFormOutput> latestTimeSeriesDataPointForms) {
            this.latestTimeSeriesDataPointForms = TimeSeriesDataPointSummaryFormOutputListCopier.copy(latestTimeSeriesDataPointForms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder latestTimeSeriesDataPointForms(TimeSeriesDataPointSummaryFormOutput ... latestTimeSeriesDataPointForms) {
            this.latestTimeSeriesDataPointForms(Arrays.asList(latestTimeSeriesDataPointForms));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder latestTimeSeriesDataPointForms(Consumer<TimeSeriesDataPointSummaryFormOutput.Builder> ... latestTimeSeriesDataPointForms) {
            this.latestTimeSeriesDataPointForms(Stream.of(latestTimeSeriesDataPointForms).map(c -> (TimeSeriesDataPointSummaryFormOutput)((TimeSeriesDataPointSummaryFormOutput.Builder)TimeSeriesDataPointSummaryFormOutput.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getOwningProjectId() {
            return this.owningProjectId;
        }

        public final void setOwningProjectId(String owningProjectId) {
            this.owningProjectId = owningProjectId;
        }

        @Override
        public final Builder owningProjectId(String owningProjectId) {
            this.owningProjectId = owningProjectId;
            return this;
        }

        public AssetListing build() {
            return new AssetListing(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AssetListing> {
        public Builder assetId(String var1);

        public Builder assetRevision(String var1);

        public Builder assetType(String var1);

        public Builder createdAt(Instant var1);

        public Builder forms(String var1);

        public Builder glossaryTerms(Collection<DetailedGlossaryTerm> var1);

        public Builder glossaryTerms(DetailedGlossaryTerm ... var1);

        public Builder glossaryTerms(Consumer<DetailedGlossaryTerm.Builder> ... var1);

        public Builder latestTimeSeriesDataPointForms(Collection<TimeSeriesDataPointSummaryFormOutput> var1);

        public Builder latestTimeSeriesDataPointForms(TimeSeriesDataPointSummaryFormOutput ... var1);

        public Builder latestTimeSeriesDataPointForms(Consumer<TimeSeriesDataPointSummaryFormOutput.Builder> ... var1);

        public Builder owningProjectId(String var1);
    }
}

