/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.datazone.model.TrackingAssetsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SageMakerRunConfigurationOutput
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SageMakerRunConfigurationOutput> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("accountId").getter(SageMakerRunConfigurationOutput.getter(SageMakerRunConfigurationOutput::accountId)).setter(SageMakerRunConfigurationOutput.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountId").build()}).build();
    private static final SdkField<String> REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("region").getter(SageMakerRunConfigurationOutput.getter(SageMakerRunConfigurationOutput::region)).setter(SageMakerRunConfigurationOutput.setter(Builder::region)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("region").build()}).build();
    private static final SdkField<Map<String, List<String>>> TRACKING_ASSETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("trackingAssets").getter(SageMakerRunConfigurationOutput.getter(SageMakerRunConfigurationOutput::trackingAssets)).setter(SageMakerRunConfigurationOutput.setter(Builder::trackingAssets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trackingAssets").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD, REGION_FIELD, TRACKING_ASSETS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SageMakerRunConfigurationOutput.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String accountId;
    private final String region;
    private final Map<String, List<String>> trackingAssets;

    private SageMakerRunConfigurationOutput(BuilderImpl builder) {
        this.accountId = builder.accountId;
        this.region = builder.region;
        this.trackingAssets = builder.trackingAssets;
    }

    public final String accountId() {
        return this.accountId;
    }

    public final String region() {
        return this.region;
    }

    public final boolean hasTrackingAssets() {
        return this.trackingAssets != null && !(this.trackingAssets instanceof SdkAutoConstructMap);
    }

    public final Map<String, List<String>> trackingAssets() {
        return this.trackingAssets;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.region());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTrackingAssets() ? this.trackingAssets() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SageMakerRunConfigurationOutput)) {
            return false;
        }
        SageMakerRunConfigurationOutput other = (SageMakerRunConfigurationOutput)obj;
        return Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.region(), other.region()) && this.hasTrackingAssets() == other.hasTrackingAssets() && Objects.equals(this.trackingAssets(), other.trackingAssets());
    }

    public final String toString() {
        return ToString.builder((String)"SageMakerRunConfigurationOutput").add("AccountId", (Object)this.accountId()).add("Region", (Object)this.region()).add("TrackingAssets", this.hasTrackingAssets() ? this.trackingAssets() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "accountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "region": {
                return Optional.ofNullable(clazz.cast(this.region()));
            }
            case "trackingAssets": {
                return Optional.ofNullable(clazz.cast(this.trackingAssets()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("accountId", ACCOUNT_ID_FIELD);
        map.put("region", REGION_FIELD);
        map.put("trackingAssets", TRACKING_ASSETS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SageMakerRunConfigurationOutput, T> g) {
        return obj -> g.apply((SageMakerRunConfigurationOutput)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String accountId;
        private String region;
        private Map<String, List<String>> trackingAssets = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SageMakerRunConfigurationOutput model) {
            this.accountId(model.accountId);
            this.region(model.region);
            this.trackingAssets(model.trackingAssets);
        }

        public final String getAccountId() {
            return this.accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getRegion() {
            return this.region;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final Map<String, ? extends Collection<String>> getTrackingAssets() {
            if (this.trackingAssets instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.trackingAssets;
        }

        public final void setTrackingAssets(Map<String, ? extends Collection<String>> trackingAssets) {
            this.trackingAssets = TrackingAssetsCopier.copy(trackingAssets);
        }

        @Override
        public final Builder trackingAssets(Map<String, ? extends Collection<String>> trackingAssets) {
            this.trackingAssets = TrackingAssetsCopier.copy(trackingAssets);
            return this;
        }

        public SageMakerRunConfigurationOutput build() {
            return new SageMakerRunConfigurationOutput(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SageMakerRunConfigurationOutput> {
        public Builder accountId(String var1);

        public Builder region(String var1);

        public Builder trackingAssets(Map<String, ? extends Collection<String>> var1);
    }
}

