/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.datazone.model.RuleProjectIdentifierListCopier;
import software.amazon.awssdk.services.datazone.model.RuleScopeSelectionMode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ProjectsForRule
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ProjectsForRule> {
    private static final SdkField<String> SELECTION_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("selectionMode").getter(ProjectsForRule.getter(ProjectsForRule::selectionModeAsString)).setter(ProjectsForRule.setter(Builder::selectionMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("selectionMode").build()}).build();
    private static final SdkField<List<String>> SPECIFIC_PROJECTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("specificProjects").getter(ProjectsForRule.getter(ProjectsForRule::specificProjects)).setter(ProjectsForRule.setter(Builder::specificProjects)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("specificProjects").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SELECTION_MODE_FIELD, SPECIFIC_PROJECTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ProjectsForRule.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String selectionMode;
    private final List<String> specificProjects;

    private ProjectsForRule(BuilderImpl builder) {
        this.selectionMode = builder.selectionMode;
        this.specificProjects = builder.specificProjects;
    }

    public final RuleScopeSelectionMode selectionMode() {
        return RuleScopeSelectionMode.fromValue(this.selectionMode);
    }

    public final String selectionModeAsString() {
        return this.selectionMode;
    }

    public final boolean hasSpecificProjects() {
        return this.specificProjects != null && !(this.specificProjects instanceof SdkAutoConstructList);
    }

    public final List<String> specificProjects() {
        return this.specificProjects;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.selectionModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSpecificProjects() ? this.specificProjects() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProjectsForRule)) {
            return false;
        }
        ProjectsForRule other = (ProjectsForRule)obj;
        return Objects.equals(this.selectionModeAsString(), other.selectionModeAsString()) && this.hasSpecificProjects() == other.hasSpecificProjects() && Objects.equals(this.specificProjects(), other.specificProjects());
    }

    public final String toString() {
        return ToString.builder((String)"ProjectsForRule").add("SelectionMode", (Object)this.selectionModeAsString()).add("SpecificProjects", this.hasSpecificProjects() ? this.specificProjects() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "selectionMode": {
                return Optional.ofNullable(clazz.cast(this.selectionModeAsString()));
            }
            case "specificProjects": {
                return Optional.ofNullable(clazz.cast(this.specificProjects()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("selectionMode", SELECTION_MODE_FIELD);
        map.put("specificProjects", SPECIFIC_PROJECTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ProjectsForRule, T> g) {
        return obj -> g.apply((ProjectsForRule)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String selectionMode;
        private List<String> specificProjects = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ProjectsForRule model) {
            this.selectionMode(model.selectionMode);
            this.specificProjects(model.specificProjects);
        }

        public final String getSelectionMode() {
            return this.selectionMode;
        }

        public final void setSelectionMode(String selectionMode) {
            this.selectionMode = selectionMode;
        }

        @Override
        public final Builder selectionMode(String selectionMode) {
            this.selectionMode = selectionMode;
            return this;
        }

        @Override
        public final Builder selectionMode(RuleScopeSelectionMode selectionMode) {
            this.selectionMode(selectionMode == null ? null : selectionMode.toString());
            return this;
        }

        public final Collection<String> getSpecificProjects() {
            if (this.specificProjects instanceof SdkAutoConstructList) {
                return null;
            }
            return this.specificProjects;
        }

        public final void setSpecificProjects(Collection<String> specificProjects) {
            this.specificProjects = RuleProjectIdentifierListCopier.copy(specificProjects);
        }

        @Override
        public final Builder specificProjects(Collection<String> specificProjects) {
            this.specificProjects = RuleProjectIdentifierListCopier.copy(specificProjects);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder specificProjects(String ... specificProjects) {
            this.specificProjects(Arrays.asList(specificProjects));
            return this;
        }

        public ProjectsForRule build() {
            return new ProjectsForRule(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ProjectsForRule> {
        public Builder selectionMode(String var1);

        public Builder selectionMode(RuleScopeSelectionMode var1);

        public Builder specificProjects(Collection<String> var1);

        public Builder specificProjects(String ... var1);
    }
}

