/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.datazone.model.OwnerGroupPropertiesOutput;
import software.amazon.awssdk.services.datazone.model.OwnerUserPropertiesOutput;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OwnerPropertiesOutput
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OwnerPropertiesOutput> {
    private static final SdkField<OwnerGroupPropertiesOutput> GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("group").getter(OwnerPropertiesOutput.getter(OwnerPropertiesOutput::group)).setter(OwnerPropertiesOutput.setter(Builder::group)).constructor(OwnerGroupPropertiesOutput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("group").build()}).build();
    private static final SdkField<OwnerUserPropertiesOutput> USER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("user").getter(OwnerPropertiesOutput.getter(OwnerPropertiesOutput::user)).setter(OwnerPropertiesOutput.setter(Builder::user)).constructor(OwnerUserPropertiesOutput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("user").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUP_FIELD, USER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = OwnerPropertiesOutput.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final OwnerGroupPropertiesOutput group;
    private final OwnerUserPropertiesOutput user;
    private final Type type;

    private OwnerPropertiesOutput(BuilderImpl builder) {
        this.group = builder.group;
        this.user = builder.user;
        this.type = builder.type;
    }

    public final OwnerGroupPropertiesOutput group() {
        return this.group;
    }

    public final OwnerUserPropertiesOutput user() {
        return this.user;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.group());
        hashCode = 31 * hashCode + Objects.hashCode(this.user());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OwnerPropertiesOutput)) {
            return false;
        }
        OwnerPropertiesOutput other = (OwnerPropertiesOutput)obj;
        return Objects.equals(this.group(), other.group()) && Objects.equals(this.user(), other.user());
    }

    public final String toString() {
        return ToString.builder((String)"OwnerPropertiesOutput").add("Group", (Object)this.group()).add("User", (Object)this.user()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "group": {
                return Optional.ofNullable(clazz.cast(this.group()));
            }
            case "user": {
                return Optional.ofNullable(clazz.cast(this.user()));
            }
        }
        return Optional.empty();
    }

    public static OwnerPropertiesOutput fromGroup(OwnerGroupPropertiesOutput group) {
        return (OwnerPropertiesOutput)OwnerPropertiesOutput.builder().group(group).build();
    }

    public static OwnerPropertiesOutput fromGroup(Consumer<OwnerGroupPropertiesOutput.Builder> group) {
        OwnerGroupPropertiesOutput.Builder builder = OwnerGroupPropertiesOutput.builder();
        group.accept(builder);
        return OwnerPropertiesOutput.fromGroup((OwnerGroupPropertiesOutput)builder.build());
    }

    public static OwnerPropertiesOutput fromUser(OwnerUserPropertiesOutput user) {
        return (OwnerPropertiesOutput)OwnerPropertiesOutput.builder().user(user).build();
    }

    public static OwnerPropertiesOutput fromUser(Consumer<OwnerUserPropertiesOutput.Builder> user) {
        OwnerUserPropertiesOutput.Builder builder = OwnerUserPropertiesOutput.builder();
        user.accept(builder);
        return OwnerPropertiesOutput.fromUser((OwnerUserPropertiesOutput)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("group", GROUP_FIELD);
        map.put("user", USER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OwnerPropertiesOutput, T> g) {
        return obj -> g.apply((OwnerPropertiesOutput)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        GROUP,
        USER,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private OwnerGroupPropertiesOutput group;
        private OwnerUserPropertiesOutput user;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(OwnerPropertiesOutput model) {
            this.group(model.group);
            this.user(model.user);
        }

        public final OwnerGroupPropertiesOutput.Builder getGroup() {
            return this.group != null ? this.group.toBuilder() : null;
        }

        public final void setGroup(OwnerGroupPropertiesOutput.BuilderImpl group) {
            OwnerGroupPropertiesOutput oldValue = this.group;
            this.group = group != null ? group.build() : null;
            this.handleUnionValueChange(Type.GROUP, oldValue, this.group);
        }

        @Override
        public final Builder group(OwnerGroupPropertiesOutput group) {
            OwnerGroupPropertiesOutput oldValue = this.group;
            this.group = group;
            this.handleUnionValueChange(Type.GROUP, oldValue, this.group);
            return this;
        }

        public final OwnerUserPropertiesOutput.Builder getUser() {
            return this.user != null ? this.user.toBuilder() : null;
        }

        public final void setUser(OwnerUserPropertiesOutput.BuilderImpl user) {
            OwnerUserPropertiesOutput oldValue = this.user;
            this.user = user != null ? user.build() : null;
            this.handleUnionValueChange(Type.USER, oldValue, this.user);
        }

        @Override
        public final Builder user(OwnerUserPropertiesOutput user) {
            OwnerUserPropertiesOutput oldValue = this.user;
            this.user = user;
            this.handleUnionValueChange(Type.USER, oldValue, this.user);
            return this;
        }

        public OwnerPropertiesOutput build() {
            return new OwnerPropertiesOutput(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OwnerPropertiesOutput> {
        public Builder group(OwnerGroupPropertiesOutput var1);

        default public Builder group(Consumer<OwnerGroupPropertiesOutput.Builder> group) {
            return this.group((OwnerGroupPropertiesOutput)((OwnerGroupPropertiesOutput.Builder)OwnerGroupPropertiesOutput.builder().applyMutation(group)).build());
        }

        public Builder user(OwnerUserPropertiesOutput var1);

        default public Builder user(Consumer<OwnerUserPropertiesOutput.Builder> user) {
            return this.user((OwnerUserPropertiesOutput)((OwnerUserPropertiesOutput.Builder)OwnerUserPropertiesOutput.builder().applyMutation(user)).build());
        }
    }
}

