/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.datazone.model.DataZoneResponse;
import software.amazon.awssdk.services.datazone.model.DomainStatus;
import software.amazon.awssdk.services.datazone.model.DomainVersion;
import software.amazon.awssdk.services.datazone.model.SingleSignOn;
import software.amazon.awssdk.services.datazone.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetDomainResponse
extends DataZoneResponse
implements ToCopyableBuilder<Builder, GetDomainResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(GetDomainResponse.getter(GetDomainResponse::arn)).setter(GetDomainResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(GetDomainResponse.getter(GetDomainResponse::createdAt)).setter(GetDomainResponse.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(GetDomainResponse.getter(GetDomainResponse::description)).setter(GetDomainResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> DOMAIN_EXECUTION_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("domainExecutionRole").getter(GetDomainResponse.getter(GetDomainResponse::domainExecutionRole)).setter(GetDomainResponse.setter(Builder::domainExecutionRole)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainExecutionRole").build()}).build();
    private static final SdkField<String> DOMAIN_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("domainVersion").getter(GetDomainResponse.getter(GetDomainResponse::domainVersionAsString)).setter(GetDomainResponse.setter(Builder::domainVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainVersion").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(GetDomainResponse.getter(GetDomainResponse::id)).setter(GetDomainResponse.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> KMS_KEY_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("kmsKeyIdentifier").getter(GetDomainResponse.getter(GetDomainResponse::kmsKeyIdentifier)).setter(GetDomainResponse.setter(Builder::kmsKeyIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKeyIdentifier").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastUpdatedAt").getter(GetDomainResponse.getter(GetDomainResponse::lastUpdatedAt)).setter(GetDomainResponse.setter(Builder::lastUpdatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedAt").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(GetDomainResponse.getter(GetDomainResponse::name)).setter(GetDomainResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> PORTAL_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("portalUrl").getter(GetDomainResponse.getter(GetDomainResponse::portalUrl)).setter(GetDomainResponse.setter(Builder::portalUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("portalUrl").build()}).build();
    private static final SdkField<String> ROOT_DOMAIN_UNIT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("rootDomainUnitId").getter(GetDomainResponse.getter(GetDomainResponse::rootDomainUnitId)).setter(GetDomainResponse.setter(Builder::rootDomainUnitId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rootDomainUnitId").build()}).build();
    private static final SdkField<String> SERVICE_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("serviceRole").getter(GetDomainResponse.getter(GetDomainResponse::serviceRole)).setter(GetDomainResponse.setter(Builder::serviceRole)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceRole").build()}).build();
    private static final SdkField<SingleSignOn> SINGLE_SIGN_ON_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("singleSignOn").getter(GetDomainResponse.getter(GetDomainResponse::singleSignOn)).setter(GetDomainResponse.setter(Builder::singleSignOn)).constructor(SingleSignOn::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("singleSignOn").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(GetDomainResponse.getter(GetDomainResponse::statusAsString)).setter(GetDomainResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(GetDomainResponse.getter(GetDomainResponse::tags)).setter(GetDomainResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, CREATED_AT_FIELD, DESCRIPTION_FIELD, DOMAIN_EXECUTION_ROLE_FIELD, DOMAIN_VERSION_FIELD, ID_FIELD, KMS_KEY_IDENTIFIER_FIELD, LAST_UPDATED_AT_FIELD, NAME_FIELD, PORTAL_URL_FIELD, ROOT_DOMAIN_UNIT_ID_FIELD, SERVICE_ROLE_FIELD, SINGLE_SIGN_ON_FIELD, STATUS_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetDomainResponse.memberNameToFieldInitializer();
    private final String arn;
    private final Instant createdAt;
    private final String description;
    private final String domainExecutionRole;
    private final String domainVersion;
    private final String id;
    private final String kmsKeyIdentifier;
    private final Instant lastUpdatedAt;
    private final String name;
    private final String portalUrl;
    private final String rootDomainUnitId;
    private final String serviceRole;
    private final SingleSignOn singleSignOn;
    private final String status;
    private final Map<String, String> tags;

    private GetDomainResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.createdAt = builder.createdAt;
        this.description = builder.description;
        this.domainExecutionRole = builder.domainExecutionRole;
        this.domainVersion = builder.domainVersion;
        this.id = builder.id;
        this.kmsKeyIdentifier = builder.kmsKeyIdentifier;
        this.lastUpdatedAt = builder.lastUpdatedAt;
        this.name = builder.name;
        this.portalUrl = builder.portalUrl;
        this.rootDomainUnitId = builder.rootDomainUnitId;
        this.serviceRole = builder.serviceRole;
        this.singleSignOn = builder.singleSignOn;
        this.status = builder.status;
        this.tags = builder.tags;
    }

    public final String arn() {
        return this.arn;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final String description() {
        return this.description;
    }

    public final String domainExecutionRole() {
        return this.domainExecutionRole;
    }

    public final DomainVersion domainVersion() {
        return DomainVersion.fromValue(this.domainVersion);
    }

    public final String domainVersionAsString() {
        return this.domainVersion;
    }

    public final String id() {
        return this.id;
    }

    public final String kmsKeyIdentifier() {
        return this.kmsKeyIdentifier;
    }

    public final Instant lastUpdatedAt() {
        return this.lastUpdatedAt;
    }

    public final String name() {
        return this.name;
    }

    public final String portalUrl() {
        return this.portalUrl;
    }

    public final String rootDomainUnitId() {
        return this.rootDomainUnitId;
    }

    public final String serviceRole() {
        return this.serviceRole;
    }

    public final SingleSignOn singleSignOn() {
        return this.singleSignOn;
    }

    public final DomainStatus status() {
        return DomainStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainExecutionRole());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainVersionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.portalUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.rootDomainUnitId());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceRole());
        hashCode = 31 * hashCode + Objects.hashCode(this.singleSignOn());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDomainResponse)) {
            return false;
        }
        GetDomainResponse other = (GetDomainResponse)((Object)obj);
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.domainExecutionRole(), other.domainExecutionRole()) && Objects.equals(this.domainVersionAsString(), other.domainVersionAsString()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.kmsKeyIdentifier(), other.kmsKeyIdentifier()) && Objects.equals(this.lastUpdatedAt(), other.lastUpdatedAt()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.portalUrl(), other.portalUrl()) && Objects.equals(this.rootDomainUnitId(), other.rootDomainUnitId()) && Objects.equals(this.serviceRole(), other.serviceRole()) && Objects.equals(this.singleSignOn(), other.singleSignOn()) && Objects.equals(this.statusAsString(), other.statusAsString()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"GetDomainResponse").add("Arn", (Object)this.arn()).add("CreatedAt", (Object)this.createdAt()).add("Description", (Object)this.description()).add("DomainExecutionRole", (Object)this.domainExecutionRole()).add("DomainVersion", (Object)this.domainVersionAsString()).add("Id", (Object)this.id()).add("KmsKeyIdentifier", (Object)this.kmsKeyIdentifier()).add("LastUpdatedAt", (Object)this.lastUpdatedAt()).add("Name", (Object)this.name()).add("PortalUrl", (Object)this.portalUrl()).add("RootDomainUnitId", (Object)this.rootDomainUnitId()).add("ServiceRole", (Object)this.serviceRole()).add("SingleSignOn", (Object)this.singleSignOn()).add("Status", (Object)this.statusAsString()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "domainExecutionRole": {
                return Optional.ofNullable(clazz.cast(this.domainExecutionRole()));
            }
            case "domainVersion": {
                return Optional.ofNullable(clazz.cast(this.domainVersionAsString()));
            }
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "kmsKeyIdentifier": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyIdentifier()));
            }
            case "lastUpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedAt()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "portalUrl": {
                return Optional.ofNullable(clazz.cast(this.portalUrl()));
            }
            case "rootDomainUnitId": {
                return Optional.ofNullable(clazz.cast(this.rootDomainUnitId()));
            }
            case "serviceRole": {
                return Optional.ofNullable(clazz.cast(this.serviceRole()));
            }
            case "singleSignOn": {
                return Optional.ofNullable(clazz.cast(this.singleSignOn()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("arn", ARN_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("domainExecutionRole", DOMAIN_EXECUTION_ROLE_FIELD);
        map.put("domainVersion", DOMAIN_VERSION_FIELD);
        map.put("id", ID_FIELD);
        map.put("kmsKeyIdentifier", KMS_KEY_IDENTIFIER_FIELD);
        map.put("lastUpdatedAt", LAST_UPDATED_AT_FIELD);
        map.put("name", NAME_FIELD);
        map.put("portalUrl", PORTAL_URL_FIELD);
        map.put("rootDomainUnitId", ROOT_DOMAIN_UNIT_ID_FIELD);
        map.put("serviceRole", SERVICE_ROLE_FIELD);
        map.put("singleSignOn", SINGLE_SIGN_ON_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetDomainResponse, T> g) {
        return obj -> g.apply((GetDomainResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DataZoneResponse.BuilderImpl
    implements Builder {
        private String arn;
        private Instant createdAt;
        private String description;
        private String domainExecutionRole;
        private String domainVersion;
        private String id;
        private String kmsKeyIdentifier;
        private Instant lastUpdatedAt;
        private String name;
        private String portalUrl;
        private String rootDomainUnitId;
        private String serviceRole;
        private SingleSignOn singleSignOn;
        private String status;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetDomainResponse model) {
            super(model);
            this.arn(model.arn);
            this.createdAt(model.createdAt);
            this.description(model.description);
            this.domainExecutionRole(model.domainExecutionRole);
            this.domainVersion(model.domainVersion);
            this.id(model.id);
            this.kmsKeyIdentifier(model.kmsKeyIdentifier);
            this.lastUpdatedAt(model.lastUpdatedAt);
            this.name(model.name);
            this.portalUrl(model.portalUrl);
            this.rootDomainUnitId(model.rootDomainUnitId);
            this.serviceRole(model.serviceRole);
            this.singleSignOn(model.singleSignOn);
            this.status(model.status);
            this.tags(model.tags);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDomainExecutionRole() {
            return this.domainExecutionRole;
        }

        public final void setDomainExecutionRole(String domainExecutionRole) {
            this.domainExecutionRole = domainExecutionRole;
        }

        @Override
        public final Builder domainExecutionRole(String domainExecutionRole) {
            this.domainExecutionRole = domainExecutionRole;
            return this;
        }

        public final String getDomainVersion() {
            return this.domainVersion;
        }

        public final void setDomainVersion(String domainVersion) {
            this.domainVersion = domainVersion;
        }

        @Override
        public final Builder domainVersion(String domainVersion) {
            this.domainVersion = domainVersion;
            return this;
        }

        @Override
        public final Builder domainVersion(DomainVersion domainVersion) {
            this.domainVersion(domainVersion == null ? null : domainVersion.toString());
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getKmsKeyIdentifier() {
            return this.kmsKeyIdentifier;
        }

        public final void setKmsKeyIdentifier(String kmsKeyIdentifier) {
            this.kmsKeyIdentifier = kmsKeyIdentifier;
        }

        @Override
        public final Builder kmsKeyIdentifier(String kmsKeyIdentifier) {
            this.kmsKeyIdentifier = kmsKeyIdentifier;
            return this;
        }

        public final Instant getLastUpdatedAt() {
            return this.lastUpdatedAt;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getPortalUrl() {
            return this.portalUrl;
        }

        public final void setPortalUrl(String portalUrl) {
            this.portalUrl = portalUrl;
        }

        @Override
        public final Builder portalUrl(String portalUrl) {
            this.portalUrl = portalUrl;
            return this;
        }

        public final String getRootDomainUnitId() {
            return this.rootDomainUnitId;
        }

        public final void setRootDomainUnitId(String rootDomainUnitId) {
            this.rootDomainUnitId = rootDomainUnitId;
        }

        @Override
        public final Builder rootDomainUnitId(String rootDomainUnitId) {
            this.rootDomainUnitId = rootDomainUnitId;
            return this;
        }

        public final String getServiceRole() {
            return this.serviceRole;
        }

        public final void setServiceRole(String serviceRole) {
            this.serviceRole = serviceRole;
        }

        @Override
        public final Builder serviceRole(String serviceRole) {
            this.serviceRole = serviceRole;
            return this;
        }

        public final SingleSignOn.Builder getSingleSignOn() {
            return this.singleSignOn != null ? this.singleSignOn.toBuilder() : null;
        }

        public final void setSingleSignOn(SingleSignOn.BuilderImpl singleSignOn) {
            this.singleSignOn = singleSignOn != null ? singleSignOn.build() : null;
        }

        @Override
        public final Builder singleSignOn(SingleSignOn singleSignOn) {
            this.singleSignOn = singleSignOn;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(DomainStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        public GetDomainResponse build() {
            return new GetDomainResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends DataZoneResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetDomainResponse> {
        public Builder arn(String var1);

        public Builder createdAt(Instant var1);

        public Builder description(String var1);

        public Builder domainExecutionRole(String var1);

        public Builder domainVersion(String var1);

        public Builder domainVersion(DomainVersion var1);

        public Builder id(String var1);

        public Builder kmsKeyIdentifier(String var1);

        public Builder lastUpdatedAt(Instant var1);

        public Builder name(String var1);

        public Builder portalUrl(String var1);

        public Builder rootDomainUnitId(String var1);

        public Builder serviceRole(String var1);

        public Builder singleSignOn(SingleSignOn var1);

        default public Builder singleSignOn(Consumer<SingleSignOn.Builder> singleSignOn) {
            return this.singleSignOn((SingleSignOn)((SingleSignOn.Builder)SingleSignOn.builder().applyMutation(singleSignOn)).build());
        }

        public Builder status(String var1);

        public Builder status(DomainStatus var1);

        public Builder tags(Map<String, String> var1);
    }
}

