/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum FilterExpressionType {
    INCLUDE("INCLUDE"),
    EXCLUDE("EXCLUDE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, FilterExpressionType> VALUE_MAP;
    private final String value;

    private FilterExpressionType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static FilterExpressionType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<FilterExpressionType> knownValues() {
        EnumSet<FilterExpressionType> knownValues = EnumSet.allOf(FilterExpressionType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(FilterExpressionType.class, FilterExpressionType::toString);
    }
}

