/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.datazone.model.RuleAssetTypeListCopier;
import software.amazon.awssdk.services.datazone.model.RuleScopeSelectionMode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AssetTypesForRule
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AssetTypesForRule> {
    private static final SdkField<String> SELECTION_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("selectionMode").getter(AssetTypesForRule.getter(AssetTypesForRule::selectionModeAsString)).setter(AssetTypesForRule.setter(Builder::selectionMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("selectionMode").build()}).build();
    private static final SdkField<List<String>> SPECIFIC_ASSET_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("specificAssetTypes").getter(AssetTypesForRule.getter(AssetTypesForRule::specificAssetTypes)).setter(AssetTypesForRule.setter(Builder::specificAssetTypes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("specificAssetTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SELECTION_MODE_FIELD, SPECIFIC_ASSET_TYPES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AssetTypesForRule.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String selectionMode;
    private final List<String> specificAssetTypes;

    private AssetTypesForRule(BuilderImpl builder) {
        this.selectionMode = builder.selectionMode;
        this.specificAssetTypes = builder.specificAssetTypes;
    }

    public final RuleScopeSelectionMode selectionMode() {
        return RuleScopeSelectionMode.fromValue(this.selectionMode);
    }

    public final String selectionModeAsString() {
        return this.selectionMode;
    }

    public final boolean hasSpecificAssetTypes() {
        return this.specificAssetTypes != null && !(this.specificAssetTypes instanceof SdkAutoConstructList);
    }

    public final List<String> specificAssetTypes() {
        return this.specificAssetTypes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.selectionModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSpecificAssetTypes() ? this.specificAssetTypes() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssetTypesForRule)) {
            return false;
        }
        AssetTypesForRule other = (AssetTypesForRule)obj;
        return Objects.equals(this.selectionModeAsString(), other.selectionModeAsString()) && this.hasSpecificAssetTypes() == other.hasSpecificAssetTypes() && Objects.equals(this.specificAssetTypes(), other.specificAssetTypes());
    }

    public final String toString() {
        return ToString.builder((String)"AssetTypesForRule").add("SelectionMode", (Object)this.selectionModeAsString()).add("SpecificAssetTypes", this.hasSpecificAssetTypes() ? this.specificAssetTypes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "selectionMode": {
                return Optional.ofNullable(clazz.cast(this.selectionModeAsString()));
            }
            case "specificAssetTypes": {
                return Optional.ofNullable(clazz.cast(this.specificAssetTypes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("selectionMode", SELECTION_MODE_FIELD);
        map.put("specificAssetTypes", SPECIFIC_ASSET_TYPES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AssetTypesForRule, T> g) {
        return obj -> g.apply((AssetTypesForRule)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String selectionMode;
        private List<String> specificAssetTypes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AssetTypesForRule model) {
            this.selectionMode(model.selectionMode);
            this.specificAssetTypes(model.specificAssetTypes);
        }

        public final String getSelectionMode() {
            return this.selectionMode;
        }

        public final void setSelectionMode(String selectionMode) {
            this.selectionMode = selectionMode;
        }

        @Override
        public final Builder selectionMode(String selectionMode) {
            this.selectionMode = selectionMode;
            return this;
        }

        @Override
        public final Builder selectionMode(RuleScopeSelectionMode selectionMode) {
            this.selectionMode(selectionMode == null ? null : selectionMode.toString());
            return this;
        }

        public final Collection<String> getSpecificAssetTypes() {
            if (this.specificAssetTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.specificAssetTypes;
        }

        public final void setSpecificAssetTypes(Collection<String> specificAssetTypes) {
            this.specificAssetTypes = RuleAssetTypeListCopier.copy(specificAssetTypes);
        }

        @Override
        public final Builder specificAssetTypes(Collection<String> specificAssetTypes) {
            this.specificAssetTypes = RuleAssetTypeListCopier.copy(specificAssetTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder specificAssetTypes(String ... specificAssetTypes) {
            this.specificAssetTypes(Arrays.asList(specificAssetTypes));
            return this;
        }

        public AssetTypesForRule build() {
            return new AssetTypesForRule(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AssetTypesForRule> {
        public Builder selectionMode(String var1);

        public Builder selectionMode(RuleScopeSelectionMode var1);

        public Builder specificAssetTypes(Collection<String> var1);

        public Builder specificAssetTypes(String ... var1);
    }
}

