/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datasync.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.datasync.model.DataSyncRequest;
import software.amazon.awssdk.services.datasync.model.S3Config;
import software.amazon.awssdk.services.datasync.model.S3StorageClass;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateLocationS3Request
extends DataSyncRequest
implements ToCopyableBuilder<Builder, UpdateLocationS3Request> {
    private static final SdkField<String> LOCATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LocationArn").getter(UpdateLocationS3Request.getter(UpdateLocationS3Request::locationArn)).setter(UpdateLocationS3Request.setter(Builder::locationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocationArn").build()}).build();
    private static final SdkField<String> SUBDIRECTORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Subdirectory").getter(UpdateLocationS3Request.getter(UpdateLocationS3Request::subdirectory)).setter(UpdateLocationS3Request.setter(Builder::subdirectory)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Subdirectory").build()}).build();
    private static final SdkField<String> S3_STORAGE_CLASS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("S3StorageClass").getter(UpdateLocationS3Request.getter(UpdateLocationS3Request::s3StorageClassAsString)).setter(UpdateLocationS3Request.setter(Builder::s3StorageClass)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3StorageClass").build()}).build();
    private static final SdkField<S3Config> S3_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("S3Config").getter(UpdateLocationS3Request.getter(UpdateLocationS3Request::s3Config)).setter(UpdateLocationS3Request.setter(Builder::s3Config)).constructor(S3Config::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Config").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOCATION_ARN_FIELD, SUBDIRECTORY_FIELD, S3_STORAGE_CLASS_FIELD, S3_CONFIG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateLocationS3Request.memberNameToFieldInitializer();
    private final String locationArn;
    private final String subdirectory;
    private final String s3StorageClass;
    private final S3Config s3Config;

    private UpdateLocationS3Request(BuilderImpl builder) {
        super(builder);
        this.locationArn = builder.locationArn;
        this.subdirectory = builder.subdirectory;
        this.s3StorageClass = builder.s3StorageClass;
        this.s3Config = builder.s3Config;
    }

    public final String locationArn() {
        return this.locationArn;
    }

    public final String subdirectory() {
        return this.subdirectory;
    }

    public final S3StorageClass s3StorageClass() {
        return S3StorageClass.fromValue(this.s3StorageClass);
    }

    public final String s3StorageClassAsString() {
        return this.s3StorageClass;
    }

    public final S3Config s3Config() {
        return this.s3Config;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.locationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.subdirectory());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3StorageClassAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Config());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateLocationS3Request)) {
            return false;
        }
        UpdateLocationS3Request other = (UpdateLocationS3Request)((Object)obj);
        return Objects.equals(this.locationArn(), other.locationArn()) && Objects.equals(this.subdirectory(), other.subdirectory()) && Objects.equals(this.s3StorageClassAsString(), other.s3StorageClassAsString()) && Objects.equals(this.s3Config(), other.s3Config());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateLocationS3Request").add("LocationArn", (Object)this.locationArn()).add("Subdirectory", (Object)this.subdirectory()).add("S3StorageClass", (Object)this.s3StorageClassAsString()).add("S3Config", (Object)this.s3Config()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LocationArn": {
                return Optional.ofNullable(clazz.cast(this.locationArn()));
            }
            case "Subdirectory": {
                return Optional.ofNullable(clazz.cast(this.subdirectory()));
            }
            case "S3StorageClass": {
                return Optional.ofNullable(clazz.cast(this.s3StorageClassAsString()));
            }
            case "S3Config": {
                return Optional.ofNullable(clazz.cast(this.s3Config()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("LocationArn", LOCATION_ARN_FIELD);
        map.put("Subdirectory", SUBDIRECTORY_FIELD);
        map.put("S3StorageClass", S3_STORAGE_CLASS_FIELD);
        map.put("S3Config", S3_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateLocationS3Request, T> g) {
        return obj -> g.apply((UpdateLocationS3Request)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DataSyncRequest.BuilderImpl
    implements Builder {
        private String locationArn;
        private String subdirectory;
        private String s3StorageClass;
        private S3Config s3Config;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateLocationS3Request model) {
            super(model);
            this.locationArn(model.locationArn);
            this.subdirectory(model.subdirectory);
            this.s3StorageClass(model.s3StorageClass);
            this.s3Config(model.s3Config);
        }

        public final String getLocationArn() {
            return this.locationArn;
        }

        public final void setLocationArn(String locationArn) {
            this.locationArn = locationArn;
        }

        @Override
        public final Builder locationArn(String locationArn) {
            this.locationArn = locationArn;
            return this;
        }

        public final String getSubdirectory() {
            return this.subdirectory;
        }

        public final void setSubdirectory(String subdirectory) {
            this.subdirectory = subdirectory;
        }

        @Override
        public final Builder subdirectory(String subdirectory) {
            this.subdirectory = subdirectory;
            return this;
        }

        public final String getS3StorageClass() {
            return this.s3StorageClass;
        }

        public final void setS3StorageClass(String s3StorageClass) {
            this.s3StorageClass = s3StorageClass;
        }

        @Override
        public final Builder s3StorageClass(String s3StorageClass) {
            this.s3StorageClass = s3StorageClass;
            return this;
        }

        @Override
        public final Builder s3StorageClass(S3StorageClass s3StorageClass) {
            this.s3StorageClass(s3StorageClass == null ? null : s3StorageClass.toString());
            return this;
        }

        public final S3Config.Builder getS3Config() {
            return this.s3Config != null ? this.s3Config.toBuilder() : null;
        }

        public final void setS3Config(S3Config.BuilderImpl s3Config) {
            this.s3Config = s3Config != null ? s3Config.build() : null;
        }

        @Override
        public final Builder s3Config(S3Config s3Config) {
            this.s3Config = s3Config;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateLocationS3Request build() {
            return new UpdateLocationS3Request(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends DataSyncRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateLocationS3Request> {
        public Builder locationArn(String var1);

        public Builder subdirectory(String var1);

        public Builder s3StorageClass(String var1);

        public Builder s3StorageClass(S3StorageClass var1);

        public Builder s3Config(S3Config var1);

        default public Builder s3Config(Consumer<S3Config.Builder> s3Config) {
            return this.s3Config((S3Config)((S3Config.Builder)S3Config.builder().applyMutation(s3Config)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

