/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datasync.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.datasync.model.HdfsDataTransferProtection;
import software.amazon.awssdk.services.datasync.model.HdfsRpcProtection;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class QopConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, QopConfiguration> {
    private static final SdkField<String> RPC_PROTECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RpcProtection").getter(QopConfiguration.getter(QopConfiguration::rpcProtectionAsString)).setter(QopConfiguration.setter(Builder::rpcProtection)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RpcProtection").build()}).build();
    private static final SdkField<String> DATA_TRANSFER_PROTECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataTransferProtection").getter(QopConfiguration.getter(QopConfiguration::dataTransferProtectionAsString)).setter(QopConfiguration.setter(Builder::dataTransferProtection)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataTransferProtection").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RPC_PROTECTION_FIELD, DATA_TRANSFER_PROTECTION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = QopConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String rpcProtection;
    private final String dataTransferProtection;

    private QopConfiguration(BuilderImpl builder) {
        this.rpcProtection = builder.rpcProtection;
        this.dataTransferProtection = builder.dataTransferProtection;
    }

    public final HdfsRpcProtection rpcProtection() {
        return HdfsRpcProtection.fromValue(this.rpcProtection);
    }

    public final String rpcProtectionAsString() {
        return this.rpcProtection;
    }

    public final HdfsDataTransferProtection dataTransferProtection() {
        return HdfsDataTransferProtection.fromValue(this.dataTransferProtection);
    }

    public final String dataTransferProtectionAsString() {
        return this.dataTransferProtection;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.rpcProtectionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataTransferProtectionAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QopConfiguration)) {
            return false;
        }
        QopConfiguration other = (QopConfiguration)obj;
        return Objects.equals(this.rpcProtectionAsString(), other.rpcProtectionAsString()) && Objects.equals(this.dataTransferProtectionAsString(), other.dataTransferProtectionAsString());
    }

    public final String toString() {
        return ToString.builder((String)"QopConfiguration").add("RpcProtection", (Object)this.rpcProtectionAsString()).add("DataTransferProtection", (Object)this.dataTransferProtectionAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RpcProtection": {
                return Optional.ofNullable(clazz.cast(this.rpcProtectionAsString()));
            }
            case "DataTransferProtection": {
                return Optional.ofNullable(clazz.cast(this.dataTransferProtectionAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("RpcProtection", RPC_PROTECTION_FIELD);
        map.put("DataTransferProtection", DATA_TRANSFER_PROTECTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<QopConfiguration, T> g) {
        return obj -> g.apply((QopConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String rpcProtection;
        private String dataTransferProtection;

        private BuilderImpl() {
        }

        private BuilderImpl(QopConfiguration model) {
            this.rpcProtection(model.rpcProtection);
            this.dataTransferProtection(model.dataTransferProtection);
        }

        public final String getRpcProtection() {
            return this.rpcProtection;
        }

        public final void setRpcProtection(String rpcProtection) {
            this.rpcProtection = rpcProtection;
        }

        @Override
        public final Builder rpcProtection(String rpcProtection) {
            this.rpcProtection = rpcProtection;
            return this;
        }

        @Override
        public final Builder rpcProtection(HdfsRpcProtection rpcProtection) {
            this.rpcProtection(rpcProtection == null ? null : rpcProtection.toString());
            return this;
        }

        public final String getDataTransferProtection() {
            return this.dataTransferProtection;
        }

        public final void setDataTransferProtection(String dataTransferProtection) {
            this.dataTransferProtection = dataTransferProtection;
        }

        @Override
        public final Builder dataTransferProtection(String dataTransferProtection) {
            this.dataTransferProtection = dataTransferProtection;
            return this;
        }

        @Override
        public final Builder dataTransferProtection(HdfsDataTransferProtection dataTransferProtection) {
            this.dataTransferProtection(dataTransferProtection == null ? null : dataTransferProtection.toString());
            return this;
        }

        public QopConfiguration build() {
            return new QopConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, QopConfiguration> {
        public Builder rpcProtection(String var1);

        public Builder rpcProtection(HdfsRpcProtection var1);

        public Builder dataTransferProtection(String var1);

        public Builder dataTransferProtection(HdfsDataTransferProtection var1);
    }
}

