/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datasync.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.datasync.DataSyncClient;
import software.amazon.awssdk.services.datasync.internal.UserAgentUtils;
import software.amazon.awssdk.services.datasync.model.ListTaskExecutionsRequest;
import software.amazon.awssdk.services.datasync.model.ListTaskExecutionsResponse;
import software.amazon.awssdk.services.datasync.model.TaskExecutionListEntry;

public class ListTaskExecutionsIterable
implements SdkIterable<ListTaskExecutionsResponse> {
    private final DataSyncClient client;
    private final ListTaskExecutionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListTaskExecutionsIterable(DataSyncClient client, ListTaskExecutionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListTaskExecutionsResponseFetcher();
    }

    public Iterator<ListTaskExecutionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<TaskExecutionListEntry> taskExecutions() {
        Function<ListTaskExecutionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.taskExecutions() != null) {
                return response.taskExecutions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListTaskExecutionsResponseFetcher
    implements SyncPageFetcher<ListTaskExecutionsResponse> {
        private ListTaskExecutionsResponseFetcher() {
        }

        public boolean hasNextPage(ListTaskExecutionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListTaskExecutionsResponse nextPage(ListTaskExecutionsResponse previousPage) {
            if (previousPage == null) {
                return ListTaskExecutionsIterable.this.client.listTaskExecutions(ListTaskExecutionsIterable.this.firstRequest);
            }
            return ListTaskExecutionsIterable.this.client.listTaskExecutions((ListTaskExecutionsRequest)((Object)ListTaskExecutionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

