/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datasync.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.datasync.model.TagListEntry;

final class InputTagListCopier {
    InputTagListCopier() {
    }

    static List<TagListEntry> copy(Collection<? extends TagListEntry> inputTagListParam) {
        Object list;
        if (inputTagListParam == null || inputTagListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            ArrayList modifiableList = new ArrayList(inputTagListParam.size());
            inputTagListParam.forEach(entry -> modifiableList.add(entry));
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<TagListEntry> copyFromBuilder(Collection<? extends TagListEntry.Builder> inputTagListParam) {
        Object list;
        if (inputTagListParam == null || inputTagListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            ArrayList modifiableList = new ArrayList(inputTagListParam.size());
            inputTagListParam.forEach(entry -> {
                TagListEntry member = entry == null ? null : (TagListEntry)entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<TagListEntry.Builder> copyToBuilder(Collection<? extends TagListEntry> inputTagListParam) {
        Object list;
        if (inputTagListParam == null || inputTagListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            ArrayList modifiableList = new ArrayList(inputTagListParam.size());
            inputTagListParam.forEach(entry -> {
                TagListEntry.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}

