/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datasync.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.datasync.model.DataSyncRequest;
import software.amazon.awssdk.services.datasync.model.NfsMountOptions;
import software.amazon.awssdk.services.datasync.model.OnPremConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateLocationNfsRequest
extends DataSyncRequest
implements ToCopyableBuilder<Builder, UpdateLocationNfsRequest> {
    private static final SdkField<String> LOCATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LocationArn").getter(UpdateLocationNfsRequest.getter(UpdateLocationNfsRequest::locationArn)).setter(UpdateLocationNfsRequest.setter(Builder::locationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocationArn").build()}).build();
    private static final SdkField<String> SUBDIRECTORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Subdirectory").getter(UpdateLocationNfsRequest.getter(UpdateLocationNfsRequest::subdirectory)).setter(UpdateLocationNfsRequest.setter(Builder::subdirectory)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Subdirectory").build()}).build();
    private static final SdkField<OnPremConfig> ON_PREM_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OnPremConfig").getter(UpdateLocationNfsRequest.getter(UpdateLocationNfsRequest::onPremConfig)).setter(UpdateLocationNfsRequest.setter(Builder::onPremConfig)).constructor(OnPremConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OnPremConfig").build()}).build();
    private static final SdkField<NfsMountOptions> MOUNT_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MountOptions").getter(UpdateLocationNfsRequest.getter(UpdateLocationNfsRequest::mountOptions)).setter(UpdateLocationNfsRequest.setter(Builder::mountOptions)).constructor(NfsMountOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MountOptions").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOCATION_ARN_FIELD, SUBDIRECTORY_FIELD, ON_PREM_CONFIG_FIELD, MOUNT_OPTIONS_FIELD));
    private final String locationArn;
    private final String subdirectory;
    private final OnPremConfig onPremConfig;
    private final NfsMountOptions mountOptions;

    private UpdateLocationNfsRequest(BuilderImpl builder) {
        super(builder);
        this.locationArn = builder.locationArn;
        this.subdirectory = builder.subdirectory;
        this.onPremConfig = builder.onPremConfig;
        this.mountOptions = builder.mountOptions;
    }

    public final String locationArn() {
        return this.locationArn;
    }

    public final String subdirectory() {
        return this.subdirectory;
    }

    public final OnPremConfig onPremConfig() {
        return this.onPremConfig;
    }

    public final NfsMountOptions mountOptions() {
        return this.mountOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.locationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.subdirectory());
        hashCode = 31 * hashCode + Objects.hashCode(this.onPremConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.mountOptions());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateLocationNfsRequest)) {
            return false;
        }
        UpdateLocationNfsRequest other = (UpdateLocationNfsRequest)((Object)obj);
        return Objects.equals(this.locationArn(), other.locationArn()) && Objects.equals(this.subdirectory(), other.subdirectory()) && Objects.equals(this.onPremConfig(), other.onPremConfig()) && Objects.equals(this.mountOptions(), other.mountOptions());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateLocationNfsRequest").add("LocationArn", (Object)this.locationArn()).add("Subdirectory", (Object)this.subdirectory()).add("OnPremConfig", (Object)this.onPremConfig()).add("MountOptions", (Object)this.mountOptions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LocationArn": {
                return Optional.ofNullable(clazz.cast(this.locationArn()));
            }
            case "Subdirectory": {
                return Optional.ofNullable(clazz.cast(this.subdirectory()));
            }
            case "OnPremConfig": {
                return Optional.ofNullable(clazz.cast(this.onPremConfig()));
            }
            case "MountOptions": {
                return Optional.ofNullable(clazz.cast(this.mountOptions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateLocationNfsRequest, T> g) {
        return obj -> g.apply((UpdateLocationNfsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DataSyncRequest.BuilderImpl
    implements Builder {
        private String locationArn;
        private String subdirectory;
        private OnPremConfig onPremConfig;
        private NfsMountOptions mountOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateLocationNfsRequest model) {
            super(model);
            this.locationArn(model.locationArn);
            this.subdirectory(model.subdirectory);
            this.onPremConfig(model.onPremConfig);
            this.mountOptions(model.mountOptions);
        }

        public final String getLocationArn() {
            return this.locationArn;
        }

        public final void setLocationArn(String locationArn) {
            this.locationArn = locationArn;
        }

        @Override
        @Transient
        public final Builder locationArn(String locationArn) {
            this.locationArn = locationArn;
            return this;
        }

        public final String getSubdirectory() {
            return this.subdirectory;
        }

        public final void setSubdirectory(String subdirectory) {
            this.subdirectory = subdirectory;
        }

        @Override
        @Transient
        public final Builder subdirectory(String subdirectory) {
            this.subdirectory = subdirectory;
            return this;
        }

        public final OnPremConfig.Builder getOnPremConfig() {
            return this.onPremConfig != null ? this.onPremConfig.toBuilder() : null;
        }

        public final void setOnPremConfig(OnPremConfig.BuilderImpl onPremConfig) {
            this.onPremConfig = onPremConfig != null ? onPremConfig.build() : null;
        }

        @Override
        @Transient
        public final Builder onPremConfig(OnPremConfig onPremConfig) {
            this.onPremConfig = onPremConfig;
            return this;
        }

        public final NfsMountOptions.Builder getMountOptions() {
            return this.mountOptions != null ? this.mountOptions.toBuilder() : null;
        }

        public final void setMountOptions(NfsMountOptions.BuilderImpl mountOptions) {
            this.mountOptions = mountOptions != null ? mountOptions.build() : null;
        }

        @Override
        @Transient
        public final Builder mountOptions(NfsMountOptions mountOptions) {
            this.mountOptions = mountOptions;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateLocationNfsRequest build() {
            return new UpdateLocationNfsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DataSyncRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateLocationNfsRequest> {
        public Builder locationArn(String var1);

        public Builder subdirectory(String var1);

        public Builder onPremConfig(OnPremConfig var1);

        default public Builder onPremConfig(Consumer<OnPremConfig.Builder> onPremConfig) {
            return this.onPremConfig((OnPremConfig)((OnPremConfig.Builder)OnPremConfig.builder().applyMutation(onPremConfig)).build());
        }

        public Builder mountOptions(NfsMountOptions var1);

        default public Builder mountOptions(Consumer<NfsMountOptions.Builder> mountOptions) {
            return this.mountOptions((NfsMountOptions)((NfsMountOptions.Builder)NfsMountOptions.builder().applyMutation(mountOptions)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

