/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datapipeline.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.datapipeline.model.DataPipelineRequest;
import software.amazon.awssdk.services.datapipeline.model._idListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribePipelinesRequest
extends DataPipelineRequest
implements ToCopyableBuilder<Builder, DescribePipelinesRequest> {
    private static final SdkField<List<String>> PIPELINE_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("pipelineIds").getter(DescribePipelinesRequest.getter(DescribePipelinesRequest::pipelineIds)).setter(DescribePipelinesRequest.setter(Builder::pipelineIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pipelineIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PIPELINE_IDS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribePipelinesRequest.memberNameToFieldInitializer();
    private final List<String> pipelineIds;

    private DescribePipelinesRequest(BuilderImpl builder) {
        super(builder);
        this.pipelineIds = builder.pipelineIds;
    }

    public final boolean hasPipelineIds() {
        return this.pipelineIds != null && !(this.pipelineIds instanceof SdkAutoConstructList);
    }

    public final List<String> pipelineIds() {
        return this.pipelineIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPipelineIds() ? this.pipelineIds() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribePipelinesRequest)) {
            return false;
        }
        DescribePipelinesRequest other = (DescribePipelinesRequest)((Object)obj);
        return this.hasPipelineIds() == other.hasPipelineIds() && Objects.equals(this.pipelineIds(), other.pipelineIds());
    }

    public final String toString() {
        return ToString.builder((String)"DescribePipelinesRequest").add("PipelineIds", this.hasPipelineIds() ? this.pipelineIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "pipelineIds": {
                return Optional.ofNullable(clazz.cast(this.pipelineIds()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<String>>> map = new HashMap<String, SdkField<List<String>>>();
        map.put("pipelineIds", PIPELINE_IDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribePipelinesRequest, T> g) {
        return obj -> g.apply((DescribePipelinesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DataPipelineRequest.BuilderImpl
    implements Builder {
        private List<String> pipelineIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribePipelinesRequest model) {
            super(model);
            this.pipelineIds(model.pipelineIds);
        }

        public final Collection<String> getPipelineIds() {
            if (this.pipelineIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.pipelineIds;
        }

        public final void setPipelineIds(Collection<String> pipelineIds) {
            this.pipelineIds = _idListCopier.copy(pipelineIds);
        }

        @Override
        public final Builder pipelineIds(Collection<String> pipelineIds) {
            this.pipelineIds = _idListCopier.copy(pipelineIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pipelineIds(String ... pipelineIds) {
            this.pipelineIds(Arrays.asList(pipelineIds));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribePipelinesRequest build() {
            return new DescribePipelinesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends DataPipelineRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribePipelinesRequest> {
        public Builder pipelineIds(Collection<String> var1);

        public Builder pipelineIds(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

